package cn.com.servyou.service.poi;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.declare.DownloadAuthenticationStateRequest;
import cn.com.servyou.dto.declare.DownloadAuthenticationStateResultVO;
import cn.com.servyou.dto.employee.EssentialInfoFeedback;
import cn.com.servyou.dto.poi.DeclareEmployeeRequestVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

import java.util.List;

@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface ETSEmployeeDeclareRequest {
    /**
     * 人员申报验证状态更新接口
     */
    @RequestMapping(value = "/gateway/ets/iit/declare/downloadAuthenticationState", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<List<DownloadAuthenticationStateResultVO>> downloadAuthenticationState(@JSONRequestBody DownloadAuthenticationStateRequest request);

    /**
     * 人员信息登记报送
     *
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/iit/declare/declareEmployeeInfo", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> declareEmployeeInfo(@JSONRequestBody DeclareEmployeeRequestVO request);

    /**
     * 人员数据接受反馈
     *
     * @param requestId requestId
     * @return
     */
    @RequestMapping(value = "/gateway/ets/iit/declare/getEmployeeInfoFeedback", method = RequestMethod.GET)
    ApiResponse<EssentialInfoFeedback> getEmployeeInfoFeedback(@RequestParam("requestId") String requestId);
}
