package cn.com.servyou.service.poi;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.common.CustomerBaseRequest;
import cn.com.servyou.dto.common.MultiCustomerBaseRequest;
import cn.com.servyou.dto.common.SingleCustomerBaseRequest;
import cn.com.servyou.dto.poi.PoiAssessmentResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

import java.util.List;

/**
 * 生产经营所得核定信息
 *
 * @author sunjl
 * @since 20230223
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface PoiAssessmentRequest {

    /**
     * 查询核定信息
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/queryAssessment", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> queryAssessment(@JSONRequestBody MultiCustomerBaseRequest<CustomerBaseRequest> request);

    /**
     * 查询核定信息反馈
     *
     * @param requestId requestId
     * @return
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/getAssessmentFeedback", method = RequestMethod.GET)
    ApiResponse<List<PoiAssessmentResultVO>> getAssessmentFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 查询核定信息-同步(AB表)
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/querySyncAssessment", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<PoiAssessmentResultVO> querySyncAssessment(@JSONRequestBody SingleCustomerBaseRequest request);
}
