package cn.com.servyou.service.poi;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.common.MultiCustomerBaseRequest;
import cn.com.servyou.dto.poi.PoiCalculateTaxRequestVO;
import cn.com.servyou.dto.poi.PoiCustomerCalculateTaxResultVO;
import cn.com.servyou.dto.poi.PoiSyncCalculateTaxRequestVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

import java.util.List;

/**
 * 生产经营B表
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface PoiCalculateTaxRequest {

    /**
     * 算税(A表)
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/calculateTax", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> calculateTax(@JSONRequestBody MultiCustomerBaseRequest<PoiCalculateTaxRequestVO> request);

    /**
     * 算税反馈(A表)
     *
     * @param requestId requestId
     * @return
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/getCalculateTaxFeedback", method = RequestMethod.GET)
    ApiResponse<List<PoiCustomerCalculateTaxResultVO>> getCalculateTaxFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 算税-同步
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/calculateSyncTax", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<PoiCustomerCalculateTaxResultVO> calculateSyncTax(@JSONRequestBody PoiSyncCalculateTaxRequestVO request);
}
