package cn.com.servyou.service.poi;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.common.MultiCustomerBaseRequest;
import cn.com.servyou.dto.common.SingleCustomerBaseRequest;
import cn.com.servyou.dto.poi.PoiBasicResultVO;
import cn.com.servyou.dto.poi.PoiCancelRequestVO;
import cn.com.servyou.dto.poi.PoiCorrectRequestVO;
import cn.com.servyou.dto.poi.PoiDeclarationRequestVO;
import cn.com.servyou.dto.poi.PoiDeclarationResult;
import cn.com.servyou.dto.poi.PoiQueryCustomerScaleTypeResultVO;
import cn.com.servyou.dto.poi.PoiSaveCustomerScaleTypeRequestVO;
import cn.com.servyou.dto.poi.PoiSyncCorrectRequestVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

import java.util.List;

/**
 * 生产经营A表申报相关
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface PoiDeclarationRequest {

    /**
     * 查询中小微企业
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/queryCustomerScaleType", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<PoiQueryCustomerScaleTypeResultVO> queryCustomerScaleType(@JSONRequestBody SingleCustomerBaseRequest request);

    /**
     * 保存中小微企业
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/saveCustomerScaleType", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse saveCustomerScaleType(@JSONRequestBody PoiSaveCustomerScaleTypeRequestVO request);


    /**
     * 数据申报(A表)
     *
     * @param request 入参
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/declaration", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> declarationPoi(@JSONRequestBody MultiCustomerBaseRequest<PoiDeclarationRequestVO> request);

    /**
     * 申报反馈(A表)
     *
     * @param requestId requestId
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/declaration/feedback", method = RequestMethod.GET)
    ApiResponse<List<PoiDeclarationResult>> declarationPoiFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 更正申报(B表)
     *
     * @param request 入参
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/correct", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> correct(@JSONRequestBody MultiCustomerBaseRequest<PoiCorrectRequestVO> request);

    /**
     * 更正申报反馈(B表)
     *
     * @param requestId requestId
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/getCorrectFeedback", method = RequestMethod.GET)
    ApiResponse<List<PoiDeclarationResult>> getCorrectFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 作废申报(B表)
     *
     * @param request 入参
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/cancel", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> cancel(@JSONRequestBody MultiCustomerBaseRequest<PoiCancelRequestVO> request);

    /**
     * 作废申报反馈(B表)
     *
     * @param requestId requestId
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/getCancelFeedback", method = RequestMethod.GET)
    ApiResponse<List<PoiDeclarationResult>> getCancelFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 更正申报-同步
     *
     * @param requestJson 请求Json
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/syncCorrect", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<PoiBasicResultVO> syncCorrect(@JSONRequestBody PoiSyncCorrectRequestVO request);
}
