package cn.com.servyou.service.poi;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.common.MultiCustomerBaseRequest;
import cn.com.servyou.dto.poi.PoiDownloadPersonalPensionRequestVO;
import cn.com.servyou.dto.poi.PoiPersonalPensionResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

import java.util.List;

/**
 * 生产经营所得个人养老金
 *
 * @author sunjl
 * @since 20221222
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface PoiDownloadPersonalPensionRequest {

    /**
     * 下载个人养老金
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/personalPension/download", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> download(@JSONRequestBody MultiCustomerBaseRequest<PoiDownloadPersonalPensionRequestVO> request);

    /**
     * 获取下载个人养老金反馈
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/personalPension/getDownloadFeedback", method = RequestMethod.GET)
    ApiResponse<List<PoiPersonalPensionResultVO>> getDownloadFeedback(@RequestParam(value = "requestId") String requestId);

}
