package cn.com.servyou.service.poi;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.common.MultiCustomerBaseRequest;
import cn.com.servyou.dto.poi.PoiFspCalculateTaxRequestVO;
import cn.com.servyou.dto.poi.PoiFspCustomerCalculateTaxResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

import java.util.List;

/**
 * 生产经营B表算税
 *
 * @author sunjl
 * @since 20221222
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface PoiFspCalculateTaxReqeust {

    /**
     * 算税(B表)
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/fsp/calculateTax", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> calculateTax(@JSONRequestBody MultiCustomerBaseRequest<PoiFspCalculateTaxRequestVO> request);

    /**
     * 算税反馈(B表)
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/fsp/getCalculateTaxFeedback", method = RequestMethod.GET)
    ApiResponse<List<PoiFspCustomerCalculateTaxResultVO>> getCalculateTaxFeedback(@RequestParam(value = "requestId") String requestId);

}
