package cn.com.servyou.service.poi;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.common.MultiCustomerBaseRequest;
import cn.com.servyou.dto.common.SingleCustomerBaseRequest;
import cn.com.servyou.dto.poi.PoiDeclarationResult;
import cn.com.servyou.dto.poi.PoiFspCalculateTaxRequestVO;
import cn.com.servyou.dto.poi.PoiFspQueryDeclarationInfoResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

import java.util.List;

/**
 * 生产经营B表申报
 *
 * @author sunjl
 * @since 20221222
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface PoiFspDeclarationReqeust {

    /**
     * 申报(B表)
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/fsp/declaration", method = RequestMethod.POST, headers = { "Content-Type=application/json"})
    ApiResponse<AsyncResult> declaration(@JSONRequestBody MultiCustomerBaseRequest<PoiFspCalculateTaxRequestVO> request);

    /**
     * 申报反馈(B表)
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/fsp/declaration/feedback", method = RequestMethod.GET)
    ApiResponse<List<PoiDeclarationResult>> declarationPoiFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 查询申报明细(B表)
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/fsp/queryDeclarationInfoList", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<PoiFspQueryDeclarationInfoResultVO> declaration(@JSONRequestBody SingleCustomerBaseRequest request);

}
