package cn.com.servyou.service.poi;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.common.MultiCustomerBaseRequest;
import cn.com.servyou.dto.poi.PoiImportRequestVO;
import cn.com.servyou.dto.poi.PoiImportResult;
import cn.com.servyou.dto.poi.PoiSyncImportRequestVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

import java.util.List;

@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface PoiImportRequest {
    /**
     * 数据导入
     *
     * @param requestJson 请求
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/import", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> importPoi(@JSONRequestBody MultiCustomerBaseRequest<PoiImportRequestVO> request);

    /**
     * 导入反馈
     *
     * @param requestId requestId
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/import/feedback", method = RequestMethod.GET)
    ApiResponse<List<PoiImportResult>> importPoiFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 数据导入-同步
     *
     * @param requestJson 请求
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/importSync", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<PoiImportResult> importSyncPoi(@JSONRequestBody PoiSyncImportRequestVO request);
}
