package cn.com.servyou.service.poi;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.poi.PoiCancelWithholdingVoucherRequestVO;
import cn.com.servyou.dto.poi.PoiCancelWithholdingVoucherResultVO;
import cn.com.servyou.dto.poi.PoiQueryWithholdingRequest;
import cn.com.servyou.dto.poi.PoiQueryWithholdingResult;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;

/**
 * @author sunjl
 * @since 20221124
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface PoiPaymentRequest {

    /**
     * 查询申报缴税信息-同步(AB表)
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/payment/queryWithholding", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<PoiQueryWithholdingResult> queryWithholding(@JSONRequestBody PoiQueryWithholdingRequest request);

    /**
     * 作废缴款凭证
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/payment/cancelWithholdingVoucher", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<PoiCancelWithholdingVoucherResultVO> cancelWithholdingVoucher(@JSONRequestBody PoiCancelWithholdingVoucherRequestVO requestVO);

}
