package cn.com.servyou.service.poi;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.common.CustomerBaseRequest;
import cn.com.servyou.dto.common.MultiCustomerBaseRequest;
import cn.com.servyou.dto.common.SingleCustomerBaseRequest;
import cn.com.servyou.dto.poi.PoiBusinessDataResponse;
import cn.com.servyou.dto.poi.PoiQuerySecondaryResultResult;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;

import java.util.List;

/**
 * 生产经营查询
 *
 * @author sunjl
 * @since 20221222
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface PoiQueryRequest {

    /**
     * 数据查询
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/queryBusinessData", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<List<PoiBusinessDataResponse>> queryBusinessData(@JSONRequestBody MultiCustomerBaseRequest<CustomerBaseRequest> request);

    /**
     * 获取减免附表减免事项列表
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/iit/poi/secondary/query", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<PoiQuerySecondaryResultResult> querySecondary(@JSONRequestBody SingleCustomerBaseRequest request);
}
