package cn.com.servyou.service.scene;

import cn.com.servyou.dto.enums.DeclarationAppendixItemEnum;
import cn.com.servyou.dto.enums.DeclarationTypeEnum;
import cn.com.servyou.dto.enums.IncomeItemEnum;
import lombok.Data;
import lombok.RequiredArgsConstructor;

/**
 * 校验结果
 *
 * @author zhouww
 * @since 20191024
 */
@Data
@RequiredArgsConstructor
public class DataCheckResult {
    /**
     * 证照类型
     */
    private String licenseType;

    /**
     * 证照号码
     */
    private String licenseNumber;

    /**
     * 申报类型
     */
    private DeclarationTypeEnum declarationTypeEnum;

    /**
     * 报表类型
     */
    private IncomeItemEnum incomeItemEnum;

    /**
     * 附表名字
     */
    private DeclarationAppendixItemEnum tableName;

    /**
     * 错误描述
     */
    private String errorMessage;

    /**
     * 提示码
     */
    private String messageCode;

}
