package cn.com.servyou.service.scene;

import cn.com.servyou.dto.PersonUniqueKey;
import cn.com.servyou.dto.declare.CompanyDeclareRequest;
import cn.com.servyou.dto.tax.CalculateIndividualIncomeTaxRequest;
import cn.com.servyou.dto.tax.ClassificationIncome;
import cn.com.servyou.dto.tax.ClassificationIncomeRequest;
import cn.com.servyou.dto.tax.ComplexIncome;
import cn.com.servyou.dto.tax.ComplexIncomeRequest;
import cn.com.servyou.dto.tax.DetailCompanyEmployee;
import cn.com.servyou.dto.tax.InsuranceMarketingIncome;
import cn.com.servyou.dto.tax.NonResidentsIncome;
import cn.com.servyou.dto.tax.NonResidentsIncomeRequest;
import cn.com.servyou.dto.tax.NormalSalarySpecIncome;
import cn.com.servyou.dto.tax.SecuritiesBrokerIncome;
import cn.com.servyou.utils.CollectionUtil;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 校验不存在人员列表的薪资数据
 *
 * @author zhouww
 * @since 20191024
 */
public class IncomeEmployeeMappingCheck {

    /**
     * 校验申报/数据导入薪资
     * @param request request
     * @return 校验结果
     */
    public static CheckIncomeResult checkDeclareData(CompanyDeclareRequest request) {
        CheckIncomeResult checkIncomeResult = new CheckIncomeResult();
        checkIncomeResult.setComplexIncomeResultList(Collections.emptyList());
        checkIncomeResult.setClassificationIncomeList(Collections.emptyList());
        checkIncomeResult.setNonResidentsIncomeList(Collections.emptyList());
        if (null == request) {
            return checkIncomeResult;
        }
        List<DetailCompanyEmployee> employeeList = request.getCompanyEmployeeList();
        if (CollectionUtils.isEmpty(employeeList)) {
            return checkIncomeResult;
        }
        Map<PersonUniqueKey, DetailCompanyEmployee> employeeMap = new HashMap<>();
        for (DetailCompanyEmployee detailCompanyEmployee : employeeList) {
            PersonUniqueKey personUniqueKey = new PersonUniqueKey(detailCompanyEmployee.getLicenseType(), detailCompanyEmployee.getLicenseNumber());
            employeeMap.put(personUniqueKey, detailCompanyEmployee);
        }

        // 校验所有报表的薪资
        ComplexIncomeRequest complexIncomeRequest = request.getComplexIncomeRequest();
        ClassificationIncomeRequest classificationIncomeRequest = request.getClassificationIncomeRequest();
        NonResidentsIncomeRequest nonResidentsIncomeRequest = request.getNonResidentsIncomeRequest();

        List<ComplexIncome> checkComplexIncomeResultList = checkComplexIncomeRequest(complexIncomeRequest, employeeMap);
        List<ClassificationIncome> checkClassificationIncomeList =checkClassificationIncomeRequest(classificationIncomeRequest, employeeMap);
        List<NonResidentsIncome> checkNonResidentsIncomeList = checkNonResidentsIncomeRequest(nonResidentsIncomeRequest, employeeMap);
        checkIncomeResult.setComplexIncomeResultList(checkComplexIncomeResultList);
        checkIncomeResult.setClassificationIncomeList(checkClassificationIncomeList);
        checkIncomeResult.setNonResidentsIncomeList(checkNonResidentsIncomeList);
        return checkIncomeResult;
    }

    public static List<ComplexIncome> checkComplexIncomeRequest(ComplexIncomeRequest complexIncomeRequest, Map<PersonUniqueKey, DetailCompanyEmployee> employeeMap) {
        if (null == complexIncomeRequest) {
            return Collections.emptyList();
        }

        List<ComplexIncome> checkResultList = new ArrayList<>();
        NormalSalarySpecIncome normalSalarySpecIncome = complexIncomeRequest.getNormalSalarySpecIncome();
        if (null != normalSalarySpecIncome) {
            checkResultList.addAll(checkComplexIncome(normalSalarySpecIncome.getNormalSalarySpec(), employeeMap));
            checkResultList.addAll(checkComplexIncome(normalSalarySpecIncome.getLastMonthNormalSalary(), employeeMap));
        }
        InsuranceMarketingIncome insuranceMarketingIncome = complexIncomeRequest.getInsuranceMarketingIncome();
        if (null != insuranceMarketingIncome) {
            checkResultList.addAll(checkComplexIncome(insuranceMarketingIncome.getInsuranceMarketingIncomeList(), employeeMap));
            checkResultList.addAll(checkComplexIncome(insuranceMarketingIncome.getLastMonthSalary(), employeeMap));
        }
        SecuritiesBrokerIncome securitiesBrokerIncome = complexIncomeRequest.getSecuritiesBrokerIncome();
        if (null != securitiesBrokerIncome) {
            checkResultList.addAll(checkComplexIncome(securitiesBrokerIncome.getSecuritiesBrokerIncomeList(), employeeMap));
            checkResultList.addAll(checkComplexIncome(securitiesBrokerIncome.getLastMonthSalary(), employeeMap));
        }
        checkResultList.addAll(checkComplexIncome(complexIncomeRequest.getStockIncentiveList(), employeeMap));
        checkResultList.addAll(checkComplexIncome(complexIncomeRequest.getRoyaltyFeeList(), employeeMap));
        checkResultList.addAll(checkComplexIncome(complexIncomeRequest.getRetreatIncome(), employeeMap));
        checkResultList.addAll(checkComplexIncome(complexIncomeRequest.getCompensateIncome(), employeeMap));
        checkResultList.addAll(checkComplexIncome(complexIncomeRequest.getLaborRemunerationIncome(), employeeMap));
        checkResultList.addAll(checkComplexIncome(complexIncomeRequest.getAuthorsRemunerationIncome(), employeeMap));
        checkResultList.addAll(checkComplexIncome(complexIncomeRequest.getEnterpriseAnnuityList(), employeeMap));
        checkResultList.addAll(checkComplexIncome(complexIncomeRequest.getAnnualOneTimeBonusIncome(), employeeMap));
        return checkResultList;
    }

    /**
     * 校验综合所得的薪资数据
     *
     * @param complexIncomeList complexIncomeList
     * @param employeeMap employeeMap
     * @return 校验结果
     */
    public static List<ComplexIncome> checkComplexIncome(List<ComplexIncome> complexIncomeList, Map<PersonUniqueKey, DetailCompanyEmployee> employeeMap ) {
        if (CollectionUtil.isEmpty(complexIncomeList)) {
            return Collections.emptyList();
        }
        List<ComplexIncome> checkResultList = new ArrayList<>();
        for (ComplexIncome complexIncome : complexIncomeList) {
            PersonUniqueKey personUniqueKey = new PersonUniqueKey(complexIncome.getLicenseType(), complexIncome.getLicenseNumber());
            if (null == employeeMap.get(personUniqueKey)) {
                checkResultList.add(complexIncome);
            }
        }
        return checkResultList;
    }


    public static List<ClassificationIncome> checkClassificationIncomeRequest(ClassificationIncomeRequest classificationIncomeRequest, Map<PersonUniqueKey, DetailCompanyEmployee> employeeMap) {
        if (null == classificationIncomeRequest) {
            return Collections.emptyList();
        }
        List<ClassificationIncome> checkResultList = new ArrayList<>();
        checkResultList.addAll(checkClassificationIncome(classificationIncomeRequest.getInterestDividendBonusIncomes(), employeeMap));
        checkResultList.addAll(checkClassificationIncome(classificationIncomeRequest.getEquitytTransferIncomes(), employeeMap));
        checkResultList.addAll(checkClassificationIncome(classificationIncomeRequest.getOtherPropertyAssignmentIncomes(), employeeMap));
        checkResultList.addAll(checkClassificationIncome(classificationIncomeRequest.getOtherPropertyRentalIncomes(), employeeMap));
        checkResultList.addAll(checkClassificationIncome(classificationIncomeRequest.getAccidentalIncome(), employeeMap));
        checkResultList.addAll(checkClassificationIncome(classificationIncomeRequest.getListedCompanyInterest(), employeeMap));
        return checkResultList;
    }


    /**
     * 校验分类所得的薪资数据
     *
     * @param classificationIncomeList classificationIncomeList
     * @param employeeMap employeeMap
     * @return 校验结果
     */
    public static List<ClassificationIncome> checkClassificationIncome(List<ClassificationIncome> classificationIncomeList, Map<PersonUniqueKey, DetailCompanyEmployee> employeeMap) {
        if (CollectionUtil.isEmpty(classificationIncomeList)) {
            return Collections.emptyList();
        }
        List<ClassificationIncome> dataCheckResultList = new ArrayList<>();
        for (ClassificationIncome classificationIncome : classificationIncomeList) {
            PersonUniqueKey personUniqueKey = new PersonUniqueKey(classificationIncome.getLicenseType(), classificationIncome.getLicenseNumber());
            if (null == employeeMap.get(personUniqueKey)) {
                dataCheckResultList.add(classificationIncome);
            }
        }
        return dataCheckResultList;
    }

    public static List<NonResidentsIncome> checkNonResidentsIncomeRequest(NonResidentsIncomeRequest nonResidentsIncomeRequest, Map<PersonUniqueKey, DetailCompanyEmployee> employeeMap) {
        if (null == nonResidentsIncomeRequest) {
            return Collections.emptyList();
        }
        List<NonResidentsIncome> checkResultList = new ArrayList<>();
        checkResultList.addAll(checkNonResidentsIncome(nonResidentsIncomeRequest.getForeignerWagesSalaryIncomes(), employeeMap));
        checkResultList.addAll(checkNonResidentsIncome(nonResidentsIncomeRequest.getForeignerMonthsBonusIncomes(), employeeMap));
        checkResultList.addAll(checkNonResidentsIncome(nonResidentsIncomeRequest.getLaborRemunerationIncomes(), employeeMap));
        checkResultList.addAll(checkNonResidentsIncome(nonResidentsIncomeRequest.getAuthorsRemunerationIncome(), employeeMap));
        checkResultList.addAll(checkNonResidentsIncome(nonResidentsIncomeRequest.getInterestDividendBonusIncomes(), employeeMap));
        checkResultList.addAll(checkNonResidentsIncome(nonResidentsIncomeRequest.getEquitytTransferIncomes(), employeeMap));
        checkResultList.addAll(checkNonResidentsIncome(nonResidentsIncomeRequest.getOtherPropertyAssignmentIncomes(), employeeMap));
        checkResultList.addAll(checkNonResidentsIncome(nonResidentsIncomeRequest.getAccidentalIncome(), employeeMap));
        checkResultList.addAll(checkNonResidentsIncome(nonResidentsIncomeRequest.getCompensateIncomes(), employeeMap));
        return checkResultList;
    }

    /**
     * 校验非居民的薪资数据
     *
     * @param nonResidentsIncomeList nonResidentsIncomeList
     * @param employeeMap employeeMap
     * @return 校验结果
     */
    public static List<NonResidentsIncome> checkNonResidentsIncome(List<NonResidentsIncome> nonResidentsIncomeList, Map<PersonUniqueKey, DetailCompanyEmployee> employeeMap) {
        if (CollectionUtil.isEmpty(nonResidentsIncomeList)) {
            return Collections.emptyList();
        }
        List<NonResidentsIncome> dataCheckResultList = new ArrayList<>();
        for (NonResidentsIncome nonResidentsIncome : nonResidentsIncomeList) {
            PersonUniqueKey personUniqueKey = new PersonUniqueKey(nonResidentsIncome.getLicenseType(), nonResidentsIncome.getLicenseNumber());
            if (null == employeeMap.get(personUniqueKey)) {
                dataCheckResultList.add(nonResidentsIncome);
            }
        }
        return dataCheckResultList;
    }

    /**
     * 校验薪资数据
     * @param request
     */
    public static CheckIncomeResult checkCalculateData(CalculateIndividualIncomeTaxRequest request) {
        CheckIncomeResult checkIncomeResult = new CheckIncomeResult();
        checkIncomeResult.setComplexIncomeResultList(Collections.emptyList());
        checkIncomeResult.setClassificationIncomeList(Collections.emptyList());
        checkIncomeResult.setNonResidentsIncomeList(Collections.emptyList());
        if (null == request) {
            return checkIncomeResult;
        }
        ComplexIncomeRequest complexIncomeRequest = request.getComplexIncomeRequest();
        if (null == complexIncomeRequest) {
            return checkIncomeResult;
        }

        NormalSalarySpecIncome normalSalarySpecIncome = complexIncomeRequest.getNormalSalarySpecIncome();
        InsuranceMarketingIncome insuranceMarketingIncome = complexIncomeRequest.getInsuranceMarketingIncome();
        SecuritiesBrokerIncome securitiesBrokerIncome = complexIncomeRequest.getSecuritiesBrokerIncome();

        List<ComplexIncome> complexIncomeCheckList = new ArrayList<>();
        complexIncomeCheckList.addAll(checkNormalSalarySpecIncome(normalSalarySpecIncome));
        complexIncomeCheckList.addAll(checkInsuranceMarketingIncome(insuranceMarketingIncome));
        complexIncomeCheckList.addAll(checkSecuritiesBrokerIncome(securitiesBrokerIncome));
        checkIncomeResult.setComplexIncomeResultList(complexIncomeCheckList);
        return checkIncomeResult;
    }

    public static List<ComplexIncome> checkNormalSalarySpecIncome(NormalSalarySpecIncome normalSalarySpecIncome ) {
        if (null == normalSalarySpecIncome || CollectionUtil.isEmpty(normalSalarySpecIncome.getNormalSalarySpec())) {
            return Collections.emptyList();
        }
        List<ComplexIncome> normalSalarySpec = normalSalarySpecIncome.getNormalSalarySpec();
        List<DetailCompanyEmployee> companyEmployeeList = normalSalarySpecIncome.getCompanyEmployeeList();
        return checkComplexIncome(normalSalarySpec, companyEmployeeList);
    }

    public static List<ComplexIncome> checkInsuranceMarketingIncome(InsuranceMarketingIncome insuranceMarketingIncome) {
        if (null == insuranceMarketingIncome || CollectionUtil.isEmpty(insuranceMarketingIncome.getInsuranceMarketingIncomeList())) {
            return Collections.emptyList();
        }
        List<ComplexIncome> insuranceMarketingList = insuranceMarketingIncome.getInsuranceMarketingIncomeList();
        List<DetailCompanyEmployee> companyEmployeeList = insuranceMarketingIncome.getCompanyEmployeeList();
        return checkComplexIncome(insuranceMarketingList, companyEmployeeList);
    }

    public static List<ComplexIncome> checkSecuritiesBrokerIncome(SecuritiesBrokerIncome securitiesBrokerIncome){
        if (null == securitiesBrokerIncome || CollectionUtil.isEmpty(securitiesBrokerIncome.getSecuritiesBrokerIncomeList())) {
            return Collections.emptyList();
        }

        List<ComplexIncome> normalSalarySpec = securitiesBrokerIncome.getSecuritiesBrokerIncomeList();
        List<DetailCompanyEmployee> companyEmployeeList = securitiesBrokerIncome.getCompanyEmployeeList();
        return checkComplexIncome(normalSalarySpec, companyEmployeeList);
    }

    private static List<ComplexIncome> checkComplexIncome(List<ComplexIncome> normalSalarySpec, List<DetailCompanyEmployee> companyEmployeeList ) {
        if (CollectionUtil.isEmpty(companyEmployeeList)) {
            return normalSalarySpec;
        }
        Map<PersonUniqueKey, DetailCompanyEmployee> employeeMap = new HashMap<>();
        for (DetailCompanyEmployee detailCompanyEmployee : companyEmployeeList) {
            PersonUniqueKey personUniqueKey = new PersonUniqueKey(detailCompanyEmployee.getLicenseType(), detailCompanyEmployee.getLicenseNumber());
            employeeMap.put(personUniqueKey, detailCompanyEmployee);
        }
        return checkComplexIncome(normalSalarySpec, employeeMap);
    }

}
