package cn.com.servyou.service.socins;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.FillCA;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;

/**
 * @author ranjh
 * @since 20210729
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
@FillCA
public interface HrssCaRequest {

    /**
     * 批量保存CA盒子信息
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/socins/hrss/ca/batchSave", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String batchSave(@JSONRequestBody String request);

    /**
     * 查询CA盒子信息
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/socins/hrss/ca/getByInsuranceCategory", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String getByInsuranceCategory(@JSONRequestBody String request);
}
