package cn.com.servyou.service.socins;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.FillCA;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * 参停保材料下载接口
 *
 * @author ranjh
 * @since 20240125
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
@FillCA
public interface HrssPreconditionFileRequest {

    /**
     * 参保材料下载接口-发起
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/hrss/preconditionFile/downloadInsuranceRegisterAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String downloadFileInsuranceRegisterAsync(@JSONRequestBody String request);

    /**
     * 参保材料下载接口-反馈
     *
     * @param requestId 请求id
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/hrss/preconditionFile/downloadInsuranceRegisterFeedback", method = RequestMethod.GET)
    String getDownloadInsuranceRegisterFeedback(@RequestParam("requestId") String requestId);

    /**
     * 停保材料下载接口-发起
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/hrss/preconditionFile/downloadInsuranceStopAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String downloadFileInsuranceStopAsync(@JSONRequestBody String request);

    /**
     * 参保材料下载接口-反馈
     *
     * @param requestId 请求id
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/hrss/preconditionFile/downloadInsuranceStopFeedback", method = RequestMethod.GET)
    String getDownloadInsuranceStopFeedback(@RequestParam("requestId") String requestId);

}
