package cn.com.servyou.service.socins;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.FillCA;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * 人社接口
 *
 * @author zhouww
 * @since 20211028
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
@FillCA
public interface HrssRequest {

    /**
     * 参保
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employee/register", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    @Deprecated
    String register(@JSONRequestBody String request);

    /**
     * 参保反馈
     *
     * @param requestId 请求id
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employee/getRegisterFeedback", method = RequestMethod.GET)
    @Deprecated
    String getRegisterFeedback(@RequestParam("requestId") String requestId);

    /**
     * 参保
     * V2版本
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employee/v2/register", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String registerV2(@JSONRequestBody String request);

    /**
     * 参保反馈
     * V2版本
     *
     * @param requestId 请求id
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employee/v2/getRegisterFeedback", method = RequestMethod.GET)
    String getRegisterFeedbackV2(@RequestParam("requestId") String requestId);

    /**
     * 停保
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employee/stop", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    @Deprecated
    String stop(@JSONRequestBody String request);

    /**
     * 停保反馈
     *
     * @param requestId 请求id
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employee/getStopFeedback", method = RequestMethod.GET)
    @Deprecated
    String getStopFeedback(@RequestParam("requestId") String requestId);

    /**
     * 停保
     * V2版本
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employee/v2/stop", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String stopV2(@JSONRequestBody String request);

    /**
     * 停保反馈
     * V2版本
     *
     * @param requestId 请求id
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employee/v2/getStopFeedback", method = RequestMethod.GET)
    String getStopFeedbackV2(@RequestParam("requestId") String requestId);

    /**
     * 月缴费信息查询
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/paymentRadix/query", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    @Deprecated
    String queryPaymentRadix(@JSONRequestBody String request);

    /**
     * 个人月缴费基数调整
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/paymentRadixAdjustment/radixAdjustment", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    @Deprecated
    String radixAdjustment(@JSONRequestBody String request);


    /**
     * 个人月缴费基数调整反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/paymentRadixAdjustment/getRadixAdjustmentFeedback", method = RequestMethod.GET)
    @Deprecated
    String getRadixAdjustmentFeedback(@RequestParam("requestId") String requestId);

    /**
     * 个人月缴费基数调整
     * V2版本
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/paymentRadixAdjustment/v2/radixAdjustment", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String generalRadixAdjustment(@JSONRequestBody String request);


    /**
     * 个人月缴费基数调整
     * V2版本
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/paymentRadixAdjustment/v2/getRadixAdjustmentFeedback", method = RequestMethod.GET)
    String getGeneralRadixAdjustmentFeedback(@RequestParam("requestId") String requestId);


    /**
     * 获取参保名册
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/insuredEmployee/roster", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    @Deprecated
    String rosterInsuredEmployee(@JSONRequestBody String request);

    /**
     * 获取参保名册反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/insuredEmployee/getRosterFeedback", method = RequestMethod.GET)
    @Deprecated
    String getRosterInsuredEmployeeFeedback(@RequestParam("requestId") String requestId);

    /**
     * 获取参保名册V2
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/insuredEmployee/v2/roster", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String rosterInsuredEmployeeV2(@JSONRequestBody String request);

    /**
     * 获取参保名册反馈V2
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/insuredEmployee/v2/getRosterFeedback", method = RequestMethod.GET)
    String getRosterInsuredEmployeeFeedbackV2(@RequestParam("requestId") String requestId);


    /**
     * 补缴人员
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employee/sendSupplementaryPayment", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String sendSupplementaryPayment(@JSONRequestBody String request);

    /**
     * 补缴人员反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employee/getSupplementaryPaymentFeedback", method = RequestMethod.GET)
    String getSupplementaryPaymentFeedback(@RequestParam("requestId") String requestId);

    /**
     * 缴费状态查询
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/declarationSummary/download", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    @Deprecated
    String downloadDeclarationSummary(@JSONRequestBody String request);

    /**
     * 缴费状态查询反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/declarationSummary/getDownloadFeedback", method = RequestMethod.GET)
    @Deprecated
    String getDownloadDeclarationSummaryFeedback(@RequestParam("requestId") String requestId);

    /**
     * 缴费状态查询v2
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/declarationSummary/v2/download", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String downloadDeclarationSummaryV2(@JSONRequestBody String request);

    /**
     * 缴费状态查询反馈V2
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/declarationSummary/v2/getDownloadFeedback", method = RequestMethod.GET)
    String getDownloadDeclarationSummaryFeedbackV2(@RequestParam("requestId") String requestId);

    /**
     * 月缴费下载v2
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/socins/hrss/paymentRadix/v2/download", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String downloadPaymentRadixV2(@JSONRequestBody String request);

    /**
     * 月缴费查询v2
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/socins/hrss/paymentRadix/v2/getDownloadFeedback", method = RequestMethod.GET)
    String getPaymentRadixV2Feedback(@RequestParam("requestId") String requestId);

    /**
     * 人员参保类型查询
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/socins/hrss/insuranceRegisterType/v2/query", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String insuranceRegisterTypeQuery(@JSONRequestBody String request);

    /**
     * 人员参保类型查询反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/socins/hrss/insuranceRegisterType/v2/getQueryFeedback", method = RequestMethod.GET)
    String getInsuranceRegisterTypeQueryFeedback(@RequestParam("requestId") String requestId);


    /**
     * 人员补缴
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/socins/hrss/employee/v2/supplementaryPayment", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String supplementaryPaymentV2(@JSONRequestBody String request);

    /**
     * 人员补缴反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/socins/hrss/employee/v2/getSupplementaryPaymentFeedback", method = RequestMethod.GET)
    String getSupplementaryPaymentV2Feedback(@RequestParam("requestId") String requestId);


    /**
     * 深圳二次验证发起
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/socins/hrss/secondary/certificate/submitAsync", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String certificate(@JSONRequestBody String request);

    /**
     * 深圳二次验证反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/socins/hrss/secondary/certificate/feedback", method = RequestMethod.GET)
    String certificateFeedback(@RequestParam("requestId") String requestId);

    /**
     * 网厅源文件下载
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/socins/hrss/source/file/download", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String download(@JSONRequestBody String request);

    /**
     * 网厅源文件下载反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/socins/hrss/source/file/downloadFeedback", method = RequestMethod.GET)
    String downloadFeedback(@RequestParam("requestId") String requestId);

    /**
     * 网厅源文件下载-人员维度
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/pts/hrss/sourceFile/downloadEmployeeAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String downloadEmployeeAsync(@JSONRequestBody String request);

    /**
     * 网厅源文件下载反馈-人员维度
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/pts/hrss/sourceFile/downloadEmployeeFeedback", method = RequestMethod.GET)
    String downloadEmployeeFeedback(@RequestParam("requestId") String requestId);

    /**
     * 单位信息查询
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/socins/hrss/customer/queryCustomerInfoAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String queryCustomerInfo(@JSONRequestBody String request);

    /**
     * 单位信息查询反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/socins/hrss/customer/queryCustomerInfoFeedback", method = RequestMethod.GET)
    String queryCustomerInfoFeedback(@RequestParam("requestId") String requestId);

    /**
     * 招退工个人信息查询
     * V2版本
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employeeResign/v2/query", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    @Deprecated
    String queryEmployeeResign(@JSONRequestBody String request);

    /**
     * 招退工个人信息查询反馈
     * V2版本
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employeeResign/v2/getQueryFeedback", method = RequestMethod.GET)
    @Deprecated
    String getQueryEmployeeResignFeedback(@RequestParam("requestId") String requestId);

    /**
     * 查询人员状态信息
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/hrss/employee/queryEmployeeStatusAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    @Deprecated
    String queryEmployeeStatusAsync(@JSONRequestBody String request);

    /**
     * 查询人员状态信息反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/hrss/employee/queryEmployeeStatusFeedback", method = RequestMethod.GET)
    @Deprecated
    String queryEmployeeStatusFeedback(@RequestParam("requestId") String requestId);

    /**
     * 查询登录状态
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/hrss/login/getLoginResult", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    @Deprecated
    String getLoginResult(@JSONRequestBody String request);


    /**
     * 发起劳动合同备案请求
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/pts/hrss/employee/laborContract/registration", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String registration(@JSONRequestBody String request);

    /**
     * 发起劳动合同备案反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/pts/hrss/employee/laborContract/getRegistrationFeedback", method = RequestMethod.GET)
    String getRegistrationFeedback(@RequestParam("requestId") String requestId);


    /**
     * 发起劳动合同解除请求
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/pts/hrss/employee/laborContract/dissolution", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String dissolution(@JSONRequestBody String request);

    /**
     * 发起劳动合同解除反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/pts/hrss/employee/laborContract/getDissolutionFeedback", method = RequestMethod.GET)
    String getDissolutionFeedback(@RequestParam("requestId") String requestId);


}
