package cn.com.servyou.service.socins;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.FillCA;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * 人社接口-上海地区特色接口
 *
 * @author zhouww
 * @since 20211028
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
@FillCA
public interface HrssShangHaiRequest {

    /**
     * 上海新网厅参保
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employee/shanghai/register", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String shanghaiRegister(@JSONRequestBody String request);

    /**
     * 上海新网厅参保反馈
     *
     * @param requestId 请求id
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employee/shanghai/getRegisterFeedback", method = RequestMethod.GET)
    String getShanghaiRegisterFeedback(@RequestParam("requestId") String requestId);

    /**
     * 来沪人员信息采集
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employee/collect", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    @Deprecated
    String collectEmployee(@JSONRequestBody String request);

    /**
     * 来沪人员信息采集反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employee/getCollectFeedback", method = RequestMethod.GET)
    @Deprecated
    String getCollectEmployeeFeedback(@RequestParam("requestId") String requestId);

    /**
     * 招工登记
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employee/recruitRegister", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    @Deprecated
    String recruitRegister(@JSONRequestBody String request);

    /**
     * 招工登记反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employee/getRecruitRegisterFeedback", method = RequestMethod.GET)
    @Deprecated
    String getRecruitRegisterFeedback(@RequestParam("requestId") String requestId);

    /**
     * 招退工个人信息查询
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employeeResign/query", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    @Deprecated
    String queryEmployeeResign(@JSONRequestBody String request);

    /**
     * 招退工个人信息查询反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employeeResign/getQueryFeedback", method = RequestMethod.GET)
    @Deprecated
    String getQueryEmployeeResignFeedback(@RequestParam("requestId") String requestId);

    /**
     * 退工
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employee/sendResign", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    @Deprecated
    String sendResign(@JSONRequestBody String request);

    /**
     * 退工反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/employee/getResignFeedback", method = RequestMethod.GET)
    @Deprecated
    String getResignFeedback(@RequestParam("requestId") String requestId);

    /**
     * 参保登记信息预校验
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/insuranceRegisterType/query", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String queryInsuranceRegisterType(@JSONRequestBody String request);

    /**
     * 参保登记信息预校验反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/insuranceRegisterType/getQueryFeedback", method = RequestMethod.GET)
    String getQueryInsuranceRegisterTypeFeedback(@RequestParam("requestId") String requestId);

    /**
     * 上海地区新网厅，参保参数签名
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/insuranceRegister/precondition", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String insuranceRegisterPrecondition(@JSONRequestBody String request);

    /**
     * 上海地区新网厅，参保参数签名反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/insuranceRegister/getPreconditionFeedback", method = RequestMethod.GET)
    String getRegisterPreconditionFeedback(@RequestParam("requestId") String requestId);

    /**
     * 上海地区新网厅，停保参数签名
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/insuranceStop/precondition", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    @Deprecated
    String stopPrecondition(@JSONRequestBody String request);

    /**
     * 上海地区新网厅，停保参数签名反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/insuranceStop/getPreconditionFeedback", method = RequestMethod.GET)
    @Deprecated
    String getStopPreconditionFeedback(@RequestParam("requestId") String requestId);

    /**
     * 上海地区新网厅，退工参数签名
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/resign/precondition", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    @Deprecated
    String resignPrecondition(@JSONRequestBody String request);

    /**
     * 上海地区新网厅，退工参数签名反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/resign/getPreconditionFeedback", method = RequestMethod.GET)
    @Deprecated
    String getResignPreconditionFeedback(@RequestParam("requestId") String requestId);

    /**
     * 上海地区新网厅，停保参数签名V2
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/insuranceStop/v2/precondition", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String stopPreconditionV2(@JSONRequestBody String request);

    /**
     * 上海地区新网厅，停保参数签名反馈V2
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/insuranceStop/v2/getPreconditionFeedback", method = RequestMethod.GET)
    String getStopPreconditionFeedbackV2(@RequestParam("requestId") String requestId);

    /**
     * 上海地区新网厅，缴费基数调整参数签名V2
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/radixAdjustment/v2/precondition", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String radixAdjustmentPreconditionV2(@JSONRequestBody String request);

    /**
     * 上海地区新网厅，缴费基数调整签名反馈V2
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/radixAdjustment/v2/getPreconditionFeedback", method = RequestMethod.GET)
    String getRadixAdjustmentPreconditionFeedbackV2(@RequestParam("requestId") String requestId);

    /**
     * 上海地区新网厅，参保业务参数签名V2
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/insuranceRegister/v2/precondition", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String registerPreconditionV2(@JSONRequestBody String request);

    /**
     * 上海地区新网厅，参保业务参数签名反馈V2
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/hrss/insuranceRegister/v2/getPreconditionFeedback", method = RequestMethod.GET)
    String getRegisterPreconditionFeedbackV2(@RequestParam("requestId") String requestId);
}
