package cn.com.servyou.service.socins;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * 社保接口
 *
 * @author zhouww
 * @since 20211028
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface ImpositionRequest {

    /**
     * 查询企业信息
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/customer/query", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String queryCustomer(@JSONRequestBody String request);

    /**
     * 单位汇总核定信息下载
     *
     * @param request request
     * @return 请求结果
     */
    @Deprecated
    @RequestMapping(value = "/gateway/socins/imposition/queryAssessment", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String queryAssessment(@JSONRequestBody String request);

    /**
     * 单位汇总核定信息下载反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @Deprecated
    @RequestMapping(value = "/gateway/socins/imposition/getAssessmentFeedback", method = RequestMethod.GET)
    String getAssessmentFeedback(@RequestParam("requestId") String requestId);

    /**
     * 社保申报
     *
     * @param request request
     * @return 请求结果
     */
    @Deprecated
    @RequestMapping(value = "/gateway/socins/imposition/declare", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String declareImposition(@JSONRequestBody String request);

    /**
     * 社保申报反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @Deprecated
    @RequestMapping(value = "/gateway/socins/imposition/getDeclareFeedback", method = RequestMethod.GET)
    String getDeclareImpositionFeedback(@RequestParam("requestId") String requestId);

    /**
     * 单位汇总核定信息下载(新)
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/queryAssessmentAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String queryAssessmentAsync(@JSONRequestBody String request);

    /**
     * 单位汇总核定信息下载反馈(新)
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/getAssessmentFeedback", method = RequestMethod.GET)
    String getAssessmentFeedbackV2(@RequestParam("requestId") String requestId);

    /**
     * 社保申报(新)
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/declareAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String declareAsync(@JSONRequestBody String request);

    /**
     * 社保申报反馈(新)
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/getDeclareFeedback", method = RequestMethod.GET)
    String getDeclareFeedback(@RequestParam("requestId") String requestId);

    /**
     * 社保申报记录查询
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/queryDeclarationRecord", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String queryDeclarationRecord(@JSONRequestBody String request);

    /**
     * 社保申报记录查询反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/getQueryDeclarationRecordFeedback", method = RequestMethod.GET)
    String getQueryDeclarationRecordFeedback(@RequestParam("requestId") String requestId);

    /**
     * 社保打印申报记录
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/printDeclarationRecord", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String printDeclarationRecord(@JSONRequestBody String request);

    /**
     * 社保申报作废
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/cancelDeclaration", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String cancelDeclaration(@JSONRequestBody String request);

    /**
     * 社保申报作废反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/getCancelDeclarationFeedback", method = RequestMethod.GET)
    String getCancelDeclarationFeedback(@RequestParam("requestId") String requestId);

    /**
     * 三方查询
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/payment/queryAgreement", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String queryAgreement(@JSONRequestBody String request);

    /**
     * 三方查询反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/payment/getAgreementQueryFeedback", method = RequestMethod.GET)
    String getAgreementQueryFeedback(@RequestParam("requestId") String requestId);

    /**
     * 新增三方协议
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/agreement/createAgreement", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String createAgreement(@JSONRequestBody String request);

    /**
     * 新增三方协议反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/agreement/getCreateAgreementFeedback", method = RequestMethod.GET)
    String getCreateAgreementFeedback(@RequestParam("requestId") String requestId);

    /**
     * 修改三方协议号
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/agreement/updateAgreement", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String updateAgreement(@JSONRequestBody String request);

    /**
     * 修改三方协议号反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/agreement/getUpdateAgreementFeedback", method = RequestMethod.GET)
    String getUpdateAgreementFeedback(@RequestParam("requestId") String requestId);

    /**
     * 验证三方协议号
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/agreement/validAgreement", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String validAgreement(@JSONRequestBody String request);

    /**
     * 验证三方协议号反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/agreement/getValidAgreementFeedback", method = RequestMethod.GET)
    String getValidAgreementFeedback(@RequestParam("requestId") String requestId);

    /**
     * 作废三方协议号
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/agreement/invalidAgreement", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String invalidAgreement(@JSONRequestBody String request);

    /**
     * 作废三方协议号反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/agreement/getInvalidAgreementFeedback", method = RequestMethod.GET)
    String getInvalidAgreementFeedback(@RequestParam("requestId") String requestId);

    /**
     * 撤销三方协议号
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/agreement/quashAgreement", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String quashAgreement(@JSONRequestBody String request);

    /**
     * 撤销三方协议号反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/agreement/getQuashAgreementFeedback", method = RequestMethod.GET)
    String getQuashAgreementFeedback(@RequestParam("requestId") String requestId);

    /**
     * 获取银行网点配置信息查询信息
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/agreement/queryBank", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String queryBank(@JSONRequestBody String request);

    /**
     * 社保费缴纳记录查询
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/payment/queryWithheldRecord", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String queryWithheldRecord(@JSONRequestBody String request);

    /**
     * 社保费缴纳记录查询反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/payment/getWithheldRecordQueryFeedback", method = RequestMethod.GET)
    String getWithheldRecordQueryFeedback(@RequestParam("requestId") String requestId);

    /**
     * 社保缴费通知单
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/payment/downloadPayable", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String downloadPayable(@JSONRequestBody String request);

    /**
     * 社保缴费通知单反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/payment/downloadPayableFeedback", method = RequestMethod.GET)
    String downloadPayableFeedback(@RequestParam("requestId") String requestId);

    /**
     * 社保缴费证明
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/payment/downloadPayment", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String downloadPayment(@JSONRequestBody String request);

    /**
     * 社保缴费证明反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/payment/downloadPaymentFeedback", method = RequestMethod.GET)
    String downloadPaymentFeedback(@RequestParam("requestId") String requestId);

    /**
     * 社保密码校验
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/checkPassword", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String checkPassword(@JSONRequestBody String request);

    /**
     * 新增纳税人存款账户信息
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/payment/addBankAccount", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String addBankAccount(@JSONRequestBody String request);

    /**
     * 查询纳税人存款账户信息
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/payment/queryBankAccount", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String queryBankAccount(@JSONRequestBody String request);

    /**
     * 查询纳税人存款账户信息反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/payment/getBankAccountFeedback", method = RequestMethod.GET)
    String getBankAccountFeedback(@RequestParam("requestId") String requestId);

    /**
     * 银行端缴款凭证打印作废
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/payment/cancelWithholdingPrintedVoucher", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String cancelWithholdingPrintedVoucher(@JSONRequestBody String request);

    /**
     * 银行端缴款凭证打印作废反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/payment/getCancelWithholdingPrintedVoucher", method = RequestMethod.GET)
    String getCancelWithholdingPrintedVoucher(@RequestParam("requestId") String requestId);

    /**
     * 查询可打印的完税证明
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/payment/queryWithheldCertificate", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String queryWithheldCertificate(@JSONRequestBody String request);

    /**
     * 查询可打印的完税证明反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/payment/getWithheldCertificateFeedback", method = RequestMethod.GET)
    String getWithheldCertificateFeedback(@RequestParam("requestId") String requestId);

    /**
     * 打印完税证明
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/payment/printWithheldCertificate", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String printWithheldCertificate(@JSONRequestBody String request);

    /**
     * 打印完税证明反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/payment/getPrintWithheldCertificateFeedback", method = RequestMethod.GET)
    String getPrintWithheldCertificateFeedback(@RequestParam("requestId") String requestId);

    /**
     * 查询人员缴费明细
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/paymentRadix/download", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String downloaPaymentRadix(@JSONRequestBody String request);

    /**
     * 查询人员缴费明细反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/imposition/paymentRadix/getDownloadFeedback", method = RequestMethod.GET)
    String downloaPaymentRadixFeedback(@RequestParam("requestId") String requestId);

    /**
     * 查询欠费
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/payment/queryArrearageAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String queryArrearageAsync(@JSONRequestBody String request);

    /**
     * 查询欠费反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/payment/getQueryArrearageFeedback", method = RequestMethod.GET)
    String getQueryArrearageFeedback(@RequestParam("requestId") String requestId);

    /**
     * 三方缴款
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/payment/agreementWithholdingAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String agreementWithholdingAsync(@JSONRequestBody String request);

    /**
     * 三方缴款反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/payment/getAgreementWithholdingFeedback", method = RequestMethod.GET)
    String getAgreementWithholdingV2Feedback(@RequestParam("requestId") String requestId);

    /**
     * 银行端缴款凭证打印
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/payment/printWithholdingVoucherAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String printWithholdingVoucherAsync(@JSONRequestBody String request);

    /**
     * 银行端缴款凭证打印反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/payment/getPrintWithholdingVoucherFeedback", method = RequestMethod.GET)
    String getPrintWithholdingVoucherFeedback(@RequestParam("requestId") String requestId);

    /**
     * 职工参保信息查询
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/tms/customerInsurance/download", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String downloadCustomerInsurance(@JSONRequestBody String request);

    /**
     * 获取职工参保信息查询反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/tms/customerInsurance/getDownloadFeedback", method = RequestMethod.GET)
    String downloadCustomerInsuranceFeedback(@RequestParam("requestId") String requestId);

    /**
     * 新参保人员缴费工资查询
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/tms/freshInsuredPayment/query", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String downloadFreshInsuredPayment(@JSONRequestBody String request);

    /**
     * 新参保人员缴费工资查询反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/tms/freshInsuredPayment/getQueryFeedback", method = RequestMethod.GET)
    String downloadFreshInsuredPaymentFeedback(@RequestParam("requestId") String requestId);

    /**
     * 新参保人员缴费工资申报
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/tms/freshInsuredPayment/declare", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String declareFreshInsuredPayment(@JSONRequestBody String request);

    /**
     * 新参保人员缴费工资申报反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/tms/freshInsuredPayment/getDeclareFeedback", method = RequestMethod.GET)
    String declareFreshInsuredPaymentFeedback(@RequestParam("requestId") String requestId);

    /**
     * 缴费工资申报记录查询
     *
     * @param request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/socins/tms/freshInsuredPayment/queryDeclareRecord", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String queryDeclareRecord(@JSONRequestBody String request);

    /**
     * 年度缴费工资查询
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/tms/annualPayment/queryAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String downloadAnnualPayment(@JSONRequestBody String request);

    /**
     * 年度缴费工资查询反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/tms/annualPayment/getQueryFeedback", method = RequestMethod.GET)
    String downloadAnnualPaymentFeedback(@RequestParam("requestId") String requestId);

    /**
     * 年度缴费工资申报
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/tms/annualPayment/declareAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String declareAnnualPayment(@JSONRequestBody String request);

    /**
     * 年度缴费工资申报反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/tms/annualPayment/getDeclareFeedback", method = RequestMethod.GET)
    String declareAnnualPaymentFeedback(@RequestParam("requestId") String requestId);

    /**
     * 年度缴费工资调整查询
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/tms/annualPaymentAdjust/queryAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String downloadAnnualPaymentAdjust(@JSONRequestBody String request);

    /**
     * 年度缴费工资调整查询反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/tms/annualPaymentAdjust/getQueryFeedback", method = RequestMethod.GET)
    String downloadAnnualPaymentAdjustFeedback(@RequestParam("requestId") String requestId);

    /**
     * 年度缴费工资调整申报
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/tms/annualPaymentAdjust/declareAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String declareAnnualPaymentAdjust(@JSONRequestBody String request);

    /**
     * 年度缴费工资调整申报反馈
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/tms/annualPaymentAdjust/getDeclareFeedback", method = RequestMethod.GET)
    String declareAnnualPaymentAdjustFeedback(@RequestParam("requestId") String requestId);

    /**
     * 缴费工资申报记录查询（新）
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/tms/declaration/queryDeclareRecordAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String queryDeclareRecordAsync(@JSONRequestBody String request);

    /**
     * 缴费工资申报记录查询反馈（新）
     *
     * @param requestId requestId
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/tms/declaration/getQueryDeclareRecordFeedback", method = RequestMethod.GET)
    String getQueryDeclareRecordFeedback(@RequestParam("requestId") String requestId);
}
