package cn.com.servyou.service.socins;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.FillCA;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * 社保预算能力
 *
 * @author ranjh
 * @since 20240321
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
@FillCA
public interface ImpositionTmsStandingBookRequest {

    /**
     * 社保预算账单初始化信息查询-请求
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/tms/standingBook/queryAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String queryAsync(@JSONRequestBody String request);

    /**
     * 社保预算账单初始化信息查询-反馈
     *
     * @param requestId 请求id
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/tms/standingBook/queryFeedback", method = RequestMethod.GET)
    String queryFeedback(@RequestParam("requestId") String requestId);

    /**
     * 社保预算账单计算-请求
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/tms/standingBook/calculateAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String calculateAsync(@JSONRequestBody String request);

    /**
     * 社保预算账单计算-反馈
     *
     * @param requestId 请求id
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/imposition/tms/standingBook/calculateFeedback", method = RequestMethod.GET)
    String calculateFeedback(@RequestParam("requestId") String requestId);

}
