package cn.com.servyou.utils;

import org.slf4j.LoggerFactory;

import java.lang.reflect.Field;
import java.util.logging.Logger;

/**
 * 环境检测
 *
 * @author zhouww
 * @since 20191024
 */
public class DependUtil {

    public static void main(String[] args) {
        checkDepend();
    }

    private static Logger logger = Logger.getLogger(DependUtil.class.getName());

    /**
     * 依赖检查
     */
    public static void checkDepend() {
        logger.info("[依赖检测] 正在进行依赖检测......");
        boolean missComponent = false;
        boolean existsNetwork = false;
        if (checkSpringWeb()) {
            existsNetwork = true;
        }

        if (checkOkHttp3()) {
            existsNetwork = true;
        }

        if (!existsNetwork) {
            missComponent = true;
            logger.info("[依赖检测]没有检测到网络组件，请引入：okhttp-3.14.4.jar");
        }

        if (!checkJackson()) {
            missComponent = true;
            logger.info("[依赖检测]没有jackson，请引入：jackson-2.9.9.jar");
        }

        if (!checkSlf4j()) {
            missComponent = true;
            logger.info("[依赖检测]没有slf4j, 请引入：slf4j-api-1.7.28.jar");
        }
        if (!checkLogDepend()) {
            missComponent = true;
        }
        if (missComponent) {
            logger.info("[依赖检测] 缺少依赖组件，请导入对应的依赖，已经导入请忽略！");
        }
        logger.info("[依赖检测] 依赖检测结束");
    }

    /**
     * 检查SpringWeb
     * @return
     */
    public static boolean checkSpringWeb() {
        return ClassUtil.isPresent("org.springframework.web.client.RestTemplate", DependUtil.class.getClassLoader());
    }

    /**
     * 检查OkHttp3
     * @return
     */
    public static boolean checkOkHttp3() {
        return ClassUtil.isPresent("okhttp3.OkHttpClient", DependUtil.class.getClassLoader());
    }

    /**
     * 检查Jackson
     * @return
     */
    public static boolean checkJackson() {
        return ClassUtil.isPresent("com.fasterxml.jackson.databind.ObjectMapper", DependUtil.class.getClassLoader());
    }

    /**
     * 检查Slf4j
     * @return
     */
    public static boolean checkSlf4j() {
        return ClassUtil.isPresent("org.slf4j.LoggerFactory", DependUtil.class.getClassLoader());
    }

    /**
     * 检测日志依赖
     *
     * @return
     */
    public static boolean checkLogDepend() {
        if (!checkSlf4j()) {
            return false;
        }
        org.slf4j.Logger testLogger = LoggerFactory.getLogger(DependUtil.class);
        try {
            Field stateField = LoggerFactory.class.getDeclaredField("INITIALIZATION_STATE");
            stateField.setAccessible(true);
            int slf4jInitState = (int) stateField.get(LoggerFactory.class);
            if (slf4jInitState == 4) {
                logger.info("[依赖检测]slf4j没有依赖的日志工具");
                return false;
            }
            return true;
        } catch (NoSuchFieldException | IllegalAccessException e) {
            logger.info("[依赖检测]测试slf4j，看到如下信息表示成功（如果没有换行输出指定信息则需要引入：logback-1.2.3.jar）：[依赖检测]本信息由Slf4j打印");
            testLogger.info("[依赖检测]本信息由Slf4j打印");
        }
        return false;
    }

    /**
     * 检查LogBack
     * @return
     */
    public static boolean checkLogback() {
        return ClassUtil.isPresent("ch.qos.logback.classic.Logger", DependUtil.class.getClassLoader());
    }
}
