package cn.com.servyou.utils;


import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

import java.text.MessageFormat;

public class LoggerUtil {
    public LoggerUtil() {
    }

    public static void info(Logger logger, String message, Object... params) {
        if (logger.isInfoEnabled()) {
            logger.info(format(message, params));
        }

    }

    public static void warn(Logger logger, String message, Object... params) {
        if (logger.isWarnEnabled()) {
            logger.warn(format(message, params));
        }

    }

    public static void warn(Logger logger, Throwable throwable, String message, Object... params) {
        if (logger.isWarnEnabled()) {
            logger.warn(format(message, params), throwable);
        }

    }

    public static void debug(Logger logger, String message, Object... params) {
        if (logger.isDebugEnabled()) {
            logger.debug(format(message, params));
        }

    }

    public static void debug(Logger logger, Throwable throwable, String message, Object... params) {
        if (logger.isDebugEnabled()) {
            logger.debug(format(message, params), throwable);
        }

    }

    public static void error(Logger logger, String message, Object... params) {
        if (logger.isErrorEnabled()) {
            logger.error(format(message, params));
        }

    }

    public static void businessError(Logger logger, String message, Object... params) {
        if (logger.isErrorEnabled()) {
            logger.error(MarkerFactory.getMarker("BusinessException"), format(message, params));
        }

    }

    public static void error(Logger logger, Throwable throwable, String message, Object... params) {
        if (logger.isErrorEnabled()) {
            Marker marker = null;
            if (marker != null) {
                logger.error(marker, format(message, params), throwable);
            } else {
                logger.error(format(message, params), throwable);
            }
        }

    }

    private static String format(String message, Object... params) {
        return message != null && params != null && params.length != 0 ? MessageFormat.format(message, params) : message;
    }
}
