package cn.com.servyou.utils;

import cn.com.servyou.constant.ServyouKeyConstant;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * @author wulg
 * @since 20230323
 */
public class ReadIniFileUtil {

    public static Map<String, String> readInfile(String urlPath) throws IOException {
        InputStream inputStream = new FileInputStream(urlPath);
        if (inputStream == null) {
            return new HashMap<>(2 << 2);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, ServyouKeyConstant.ENCODING_UTF8));
        Properties props = new Properties();
        props.load(br);
        Map<String, String> map = new HashMap<>(2 << 2);
        for (Object s : props.keySet()) {
            map.put(s.toString(), props.getProperty(s.toString()));
        }
        return map;
    }
}
