/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1;

import com.sansec.asn1.ASN1OctetString;
import com.sansec.asn1.ASN1OutputStream;
import com.sansec.asn1.ASN1ParsingException;
import com.sansec.asn1.ASN1Primitive;
import com.sansec.asn1.ASN1String;
import com.sansec.asn1.ASN1TaggedObject;
import com.sansec.asn1.StreamUtil;
import com.sansec.util.Arrays;
import java.io.IOException;

public class DERUniversalString
extends ASN1Primitive
implements ASN1String {
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final byte[] string;

    public static DERUniversalString getInstance(Object obj) {
        if (obj == null || obj instanceof DERUniversalString) {
            return (DERUniversalString)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (DERUniversalString)DERUniversalString.fromByteArray((byte[])obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("encoding error getInstance: " + e.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERUniversalString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof DERUniversalString) {
            return DERUniversalString.getInstance(o);
        }
        return new DERUniversalString(ASN1OctetString.getInstance(o).getOctets());
    }

    public DERUniversalString(byte[] string) {
        this.string = Arrays.clone(string);
    }

    @Override
    public String getString() {
        byte[] string;
        StringBuffer buf = new StringBuffer("#");
        try {
            string = this.getEncoded();
        }
        catch (IOException e) {
            throw new ASN1ParsingException("internal error encoding UniversalString");
        }
        for (int i = 0; i != string.length; ++i) {
            buf.append(table[string[i] >>> 4 & 0xF]);
            buf.append(table[string[i] & 0xF]);
        }
        return buf.toString();
    }

    public String toString() {
        return this.getString();
    }

    public byte[] getOctets() {
        return Arrays.clone(this.string);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.string.length) + this.string.length;
    }

    @Override
    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        out.writeEncoded(withTag, 28, this.string);
    }

    @Override
    boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof DERUniversalString)) {
            return false;
        }
        return Arrays.areEqual(this.string, ((DERUniversalString)o).string);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.string);
    }
}

