/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1;

import com.sansec.asn1.ASN1Encodable;
import com.sansec.asn1.ASN1OutputStream;
import com.sansec.asn1.ASN1Primitive;
import com.sansec.asn1.ASN1TaggedObject;
import com.sansec.asn1.StreamUtil;
import java.io.IOException;

public class DLTaggedObject
extends ASN1TaggedObject {
    public DLTaggedObject(boolean explicit, int tagNo, ASN1Encodable obj) {
        super(explicit, tagNo, obj);
    }

    @Override
    boolean isConstructed() {
        return this.explicit || this.obj.toASN1Primitive().toDLObject().isConstructed();
    }

    @Override
    int encodedLength() throws IOException {
        int length = this.obj.toASN1Primitive().toDLObject().encodedLength();
        if (this.explicit) {
            return StreamUtil.calculateTagLength(this.tagNo) + StreamUtil.calculateBodyLength(length) + length;
        }
        return StreamUtil.calculateTagLength(this.tagNo) + --length;
    }

    @Override
    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        ASN1Primitive primitive = this.obj.toASN1Primitive().toDLObject();
        int flags = 128;
        if (this.explicit || primitive.isConstructed()) {
            flags |= 0x20;
        }
        out.writeTag(withTag, flags, this.tagNo);
        if (this.explicit) {
            out.writeLength(primitive.encodedLength());
        }
        out.getDLSubStream().writePrimitive(primitive, this.explicit);
    }

    @Override
    ASN1Primitive toDLObject() {
        return this;
    }
}

