/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.cmp.query;

import com.sansec.asn1.ASN1Choice;
import com.sansec.asn1.ASN1Encodable;
import com.sansec.asn1.ASN1Integer;
import com.sansec.asn1.ASN1Object;
import com.sansec.asn1.ASN1Primitive;
import com.sansec.asn1.ASN1TaggedObject;
import com.sansec.asn1.DERIA5String;
import com.sansec.asn1.DERTaggedObject;
import java.io.IOException;
import java.math.BigInteger;

public class QueryDetail
extends ASN1Object
implements ASN1Choice {
    public static final int serialNumTAG = 0;
    public static final int commonNameTAG = 1;
    private ASN1Encodable obj;
    private int tag;

    public QueryDetail(int tag, ASN1Encodable name) {
        this.obj = name;
        this.tag = tag;
    }

    public QueryDetail(String commonName) {
        this.tag = 1;
        this.obj = new DERIA5String(commonName);
    }

    public QueryDetail(BigInteger serialNum) {
        this.tag = 0;
        this.obj = new ASN1Integer(serialNum);
    }

    public static QueryDetail getInstance(Object obj) {
        if (obj == null || obj instanceof QueryDetail) {
            return (QueryDetail)obj;
        }
        if (obj instanceof ASN1TaggedObject) {
            ASN1TaggedObject tagObj = (ASN1TaggedObject)obj;
            int tag = tagObj.getTagNo();
            switch (tag) {
                case 0: {
                    return new QueryDetail(tag, ASN1Integer.getInstance(tagObj, false));
                }
                case 1: {
                    return new QueryDetail(tag, DERIA5String.getInstance(tagObj, false));
                }
            }
        }
        if (obj instanceof byte[]) {
            try {
                return QueryDetail.getInstance(ASN1Primitive.fromByteArray((byte[])obj));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("unable to parse encoded general name");
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    public int getTagNo() {
        return this.tag;
    }

    public ASN1Encodable getDetail() {
        return this.obj;
    }

    public String toString() {
        if (this.tag == 0) {
            return "serial number = " + ((ASN1Integer)this.obj).getValue().toString(16);
        }
        return "commmon name = " + ((DERIA5String)this.obj).getString();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(false, this.tag, this.obj);
    }
}

