/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.cms;

import com.sansec.asn1.ASN1Choice;
import com.sansec.asn1.ASN1Object;
import com.sansec.asn1.ASN1Primitive;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.ASN1TaggedObject;
import com.sansec.asn1.DERTaggedObject;
import com.sansec.asn1.cms.TimeStampTokenEvidence;
import com.sansec.asn1.tsp.EvidenceRecord;

public class Evidence
extends ASN1Object
implements ASN1Choice {
    private TimeStampTokenEvidence tstEvidence;
    private EvidenceRecord ersEvidence;
    private ASN1Sequence otherEvidence;

    public Evidence(TimeStampTokenEvidence tstEvidence) {
        this.tstEvidence = tstEvidence;
    }

    public Evidence(EvidenceRecord ersEvidence) {
        this.ersEvidence = ersEvidence;
    }

    private Evidence(ASN1TaggedObject tagged) {
        if (tagged.getTagNo() == 0) {
            this.tstEvidence = TimeStampTokenEvidence.getInstance(tagged, false);
        } else if (tagged.getTagNo() == 1) {
            this.ersEvidence = EvidenceRecord.getInstance(tagged, false);
        } else if (tagged.getTagNo() == 2) {
            this.otherEvidence = ASN1Sequence.getInstance(tagged, false);
        } else {
            throw new IllegalArgumentException("unknown tag in Evidence");
        }
    }

    public static Evidence getInstance(Object obj) {
        if (obj == null || obj instanceof Evidence) {
            return (Evidence)obj;
        }
        if (obj instanceof ASN1TaggedObject) {
            return new Evidence(ASN1TaggedObject.getInstance(obj));
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public static Evidence getInstance(ASN1TaggedObject obj, boolean explicit) {
        return Evidence.getInstance(obj.getObject());
    }

    public TimeStampTokenEvidence getTstEvidence() {
        return this.tstEvidence;
    }

    public EvidenceRecord getErsEvidence() {
        return this.ersEvidence;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.tstEvidence != null) {
            return new DERTaggedObject(false, 0, this.tstEvidence);
        }
        if (this.ersEvidence != null) {
            return new DERTaggedObject(false, 1, this.ersEvidence);
        }
        return new DERTaggedObject(false, 2, this.otherEvidence);
    }
}

