/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.pkcs;

import com.sansec.asn1.ASN1EncodableVector;
import com.sansec.asn1.ASN1Integer;
import com.sansec.asn1.ASN1Object;
import com.sansec.asn1.ASN1Primitive;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.ASN1TaggedObject;
import com.sansec.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class SM2SignStructure
extends ASN1Object {
    private BigInteger r;
    private BigInteger s;

    public static SM2SignStructure getInstance(ASN1TaggedObject obj, boolean explicit) {
        return SM2SignStructure.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static SM2SignStructure getInstance(Object obj) {
        if (obj instanceof SM2SignStructure) {
            return (SM2SignStructure)obj;
        }
        if (obj != null) {
            return new SM2SignStructure(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public SM2SignStructure(BigInteger r, BigInteger s) {
        this.r = r;
        this.s = s;
    }

    public SM2SignStructure(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.r = ((ASN1Integer)e.nextElement()).getValue();
        this.s = ((ASN1Integer)e.nextElement()).getValue();
    }

    public BigInteger getR() {
        return this.r;
    }

    public BigInteger getS() {
        return this.s;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(this.getR()));
        v.add(new ASN1Integer(this.getS()));
        return new DERSequence(v);
    }
}

