/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.asn1.pkcs;

import com.sansec.asn1.pkcs.SM2CipherStructure;
import com.sansec.asn1.pkcs.SM2SignStructure;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refCipher;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refSignature;
import com.sansec.util.BigIntegerUitl;
import java.math.BigInteger;

public class SM2StructureUtil {
    public static SM2CipherStructure convert(byte[] bx, byte[] by, byte[] bm, byte[] bc) {
        BigInteger x = BigIntegerUitl.toPositiveInteger(bx);
        BigInteger y = BigIntegerUitl.toPositiveInteger(by);
        SM2CipherStructure cipherSt = new SM2CipherStructure(x, y, bc, bm);
        return cipherSt;
    }

    public static SM2CipherStructure convert(BigInteger x, BigInteger y, byte[] bm, byte[] bc) {
        x = BigIntegerUitl.toPositiveInteger(x.toByteArray());
        y = BigIntegerUitl.toPositiveInteger(y.toByteArray());
        SM2CipherStructure cipherSt = new SM2CipherStructure(x, y, bc, bm);
        return cipherSt;
    }

    public static SM2CipherStructure convert(SM2refCipher cipher) {
        int cLength = cipher.getCLength();
        BigInteger x = BigIntegerUitl.toPositiveInteger(cipher.getX());
        BigInteger y = BigIntegerUitl.toPositiveInteger(cipher.getY());
        byte[] c = new byte[cLength];
        System.arraycopy(cipher.getC(), 0, c, 0, c.length);
        byte[] m = cipher.getM();
        SM2CipherStructure cipherSt = new SM2CipherStructure(x, y, c, m);
        return cipherSt;
    }

    public static SM2refCipher convert(SM2CipherStructure cipherSt) {
        byte[] x = BigIntegerUitl.asUnsigned32ByteArray(cipherSt.getX());
        byte[] y = BigIntegerUitl.asUnsigned32ByteArray(cipherSt.getY());
        byte[] c = cipherSt.getC();
        byte[] m = cipherSt.getM();
        SM2refCipher cipher = new SM2refCipher(x, y, c, m);
        return cipher;
    }

    public static SM2SignStructure convert(BigInteger r, BigInteger s) {
        r = BigIntegerUitl.toPositiveInteger(r.toByteArray());
        s = BigIntegerUitl.toPositiveInteger(s.toByteArray());
        SM2SignStructure signatureSt = new SM2SignStructure(r, s);
        return signatureSt;
    }

    public static SM2SignStructure convert(byte[] br, byte[] bs) {
        BigInteger r = BigIntegerUitl.toPositiveInteger(br);
        BigInteger s = BigIntegerUitl.toPositiveInteger(bs);
        SM2SignStructure signatureSt = new SM2SignStructure(r, s);
        return signatureSt;
    }

    public static SM2SignStructure convert(SM2refSignature signature) {
        BigInteger r = BigIntegerUitl.toPositiveInteger(signature.getR());
        BigInteger s = BigIntegerUitl.toPositiveInteger(signature.getS());
        SM2SignStructure signatureSt = new SM2SignStructure(r, s);
        return signatureSt;
    }

    public static SM2refSignature convert(SM2SignStructure signatureSt) {
        byte[] r = BigIntegerUitl.asUnsigned32ByteArray(signatureSt.getR());
        byte[] s = BigIntegerUitl.asUnsigned32ByteArray(signatureSt.getS());
        SM2refSignature signature = new SM2refSignature(r, s);
        return signature;
    }
}

