/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.agreement;

import com.sansec.crypto.BasicAgreement;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.params.ECPrivateKeyParameters;
import com.sansec.crypto.params.ECPublicKeyParameters;
import com.sansec.math.ec.ECPoint;
import java.math.BigInteger;

public class ECDHBasicAgreement
implements BasicAgreement {
    private ECPrivateKeyParameters key;

    @Override
    public void init(CipherParameters key) {
        this.key = (ECPrivateKeyParameters)key;
    }

    @Override
    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters pubKey) {
        ECPublicKeyParameters pub = (ECPublicKeyParameters)pubKey;
        if (!pub.getParameters().equals(this.key.getParameters())) {
            throw new IllegalStateException("ECDH public key has wrong domain parameters");
        }
        ECPoint P = pub.getQ().multiply(this.key.getD()).normalize();
        if (P.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECDH");
        }
        return P.getAffineXCoord().toBigInteger();
    }
}

