/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.agreement;

import com.sansec.crypto.BasicAgreement;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.params.ECDomainParameters;
import com.sansec.crypto.params.ECPrivateKeyParameters;
import com.sansec.crypto.params.ECPublicKeyParameters;
import com.sansec.crypto.params.MQVPrivateParameters;
import com.sansec.crypto.params.MQVPublicParameters;
import com.sansec.math.ec.ECAlgorithms;
import com.sansec.math.ec.ECConstants;
import com.sansec.math.ec.ECCurve;
import com.sansec.math.ec.ECPoint;
import com.sansec.util.Properties;
import java.math.BigInteger;

public class ECMQVBasicAgreement
implements BasicAgreement {
    MQVPrivateParameters privParams;

    @Override
    public void init(CipherParameters key) {
        this.privParams = (MQVPrivateParameters)key;
    }

    @Override
    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters pubKey) {
        if (Properties.isOverrideSet("com.sansec.ec.disable_mqv")) {
            throw new IllegalStateException("ECMQV explicitly disabled");
        }
        MQVPublicParameters pubParams = (MQVPublicParameters)pubKey;
        ECPrivateKeyParameters staticPrivateKey = this.privParams.getStaticPrivateKey();
        ECDomainParameters parameters = staticPrivateKey.getParameters();
        if (!parameters.equals(pubParams.getStaticPublicKey().getParameters())) {
            throw new IllegalStateException("ECMQV public key components have wrong domain parameters");
        }
        ECPoint agreement = this.calculateMqvAgreement(parameters, staticPrivateKey, this.privParams.getEphemeralPrivateKey(), this.privParams.getEphemeralPublicKey(), pubParams.getStaticPublicKey(), pubParams.getEphemeralPublicKey()).normalize();
        if (agreement.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for MQV");
        }
        return agreement.getAffineXCoord().toBigInteger();
    }

    private ECPoint calculateMqvAgreement(ECDomainParameters parameters, ECPrivateKeyParameters d1U, ECPrivateKeyParameters d2U, ECPublicKeyParameters Q2U, ECPublicKeyParameters Q1V, ECPublicKeyParameters Q2V) {
        BigInteger n = parameters.getN();
        int e = (n.bitLength() + 1) / 2;
        BigInteger powE = ECConstants.ONE.shiftLeft(e);
        ECCurve curve = parameters.getCurve();
        ECPoint[] points = new ECPoint[]{ECAlgorithms.importPoint(curve, Q2U.getQ()), ECAlgorithms.importPoint(curve, Q1V.getQ()), ECAlgorithms.importPoint(curve, Q2V.getQ())};
        curve.normalizeAll(points);
        ECPoint q2u = points[0];
        ECPoint q1v = points[1];
        ECPoint q2v = points[2];
        BigInteger x = q2u.getAffineXCoord().toBigInteger();
        BigInteger xBar = x.mod(powE);
        BigInteger Q2UBar = xBar.setBit(e);
        BigInteger s = d1U.getD().multiply(Q2UBar).add(d2U.getD()).mod(n);
        BigInteger xPrime = q2v.getAffineXCoord().toBigInteger();
        BigInteger xPrimeBar = xPrime.mod(powE);
        BigInteger Q2VBar = xPrimeBar.setBit(e);
        BigInteger hs = parameters.getH().multiply(s).mod(n);
        return ECAlgorithms.sumOfTwoMultiplies(q1v, Q2VBar.multiply(hs).mod(n), q2v, hs);
    }
}

