/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.encodings;

import com.sansec.crypto.AsymmetricBlockCipher;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.InvalidCipherTextException;
import com.sansec.crypto.params.AsymmetricKeyParameter;
import com.sansec.crypto.params.ParametersWithRandom;

public class NoEncoding
implements AsymmetricBlockCipher {
    public static final String STRICT_LENGTH_ENABLED_PROPERTY = "com.sansec.pkcs1.strict";
    private AsymmetricBlockCipher engine;
    private boolean forEncryption;
    private boolean forPrivateKey;

    public NoEncoding(AsymmetricBlockCipher cipher) {
        this.engine = cipher;
    }

    @Override
    public int getInputBlockSize() {
        int baseBlockSize = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            ++baseBlockSize;
        }
        return baseBlockSize;
    }

    @Override
    public int getOutputBlockSize() {
        int baseBlockSize = this.engine.getOutputBlockSize();
        if (!this.forEncryption) {
            ++baseBlockSize;
        }
        return baseBlockSize;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        AsymmetricKeyParameter kParam;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            kParam = (AsymmetricKeyParameter)rParam.getParameters();
        } else {
            kParam = (AsymmetricKeyParameter)param;
        }
        this.engine.init(forEncryption, param);
        this.forPrivateKey = kParam.isPrivate();
        this.forEncryption = forEncryption;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int len) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(in, inOff, len);
        }
        return this.decodeBlock(in, inOff, len);
    }

    private byte[] encodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (inLen != this.getInputBlockSize()) {
            throw new IllegalArgumentException("input data length illegal");
        }
        byte[] block = in;
        byte[] out = this.engine.processBlock(block, inOff, inLen);
        return out;
    }

    private byte[] decodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] block = this.engine.processBlock(in, inOff, inLen);
        if (block.length < this.getOutputBlockSize()) {
            byte[] tmp = new byte[this.getOutputBlockSize()];
            System.arraycopy(block, 0, tmp, tmp.length - block.length, block.length);
            block = tmp;
        }
        if (block.length != this.getOutputBlockSize()) {
            throw new InvalidCipherTextException("block incorrect size");
        }
        return block;
    }
}

