/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.encodings;

import com.sansec.crypto.AsymmetricBlockCipher;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.InvalidCipherTextException;
import com.sansec.crypto.engines.SM2Engine;
import com.sansec.crypto.engines.SM2HsmEngine;
import com.sansec.crypto.params.ParametersWithRandom;
import com.sansec.crypto.params.SM2KeyParameters;
import com.sansec.jce.provider.SwxaProvider;

public class SM2EncryptionEncoding
implements AsymmetricBlockCipher {
    private SM2Engine engine;
    private SM2KeyParameters key;
    private boolean forEncryption;
    public static final int MAX_BLOCK_LENGTH = 136;

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (SM2KeyParameters)rParam.getParameters();
        } else {
            this.key = (SM2KeyParameters)param;
        }
        this.engine = new SM2Engine();
        if (SwxaProvider.isHsm(this.key.isPrivate(), "Cipher", "SM2")) {
            this.engine = new SM2HsmEngine();
        }
        this.engine.init(forEncryption, param);
        this.forEncryption = forEncryption;
    }

    @Override
    public int getInputBlockSize() {
        int baseBlockSize = this.engine.getInputBlockSize();
        return baseBlockSize;
    }

    @Override
    public int getOutputBlockSize() {
        int baseBlockSize = this.engine.getOutputBlockSize();
        return baseBlockSize;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(in, inOff, inLen);
        }
        return this.decodeBlock(in, inOff, inLen);
    }

    private byte[] encodeBlock(byte[] in, int inOff, int inLen) {
        if (inLen > 136) {
            throw new IllegalArgumentException("input data too large");
        }
        return this.engine.processBlock(in, inOff, inLen);
    }

    private byte[] decodeBlock(byte[] in, int inOff, int inLen) {
        byte[] block = this.engine.processBlock(in, inOff, inLen);
        return block;
    }
}

