/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.engines;

import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.DataLengthException;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.engines.RSAEngine;
import com.sansec.crypto.params.ParametersWithRandom;
import com.sansec.crypto.params.RSAKeyParameters;
import com.sansec.crypto.params.RSAPrivateCrtKeyParameters;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.IRSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.IRSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPrivateKeyEx;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPrivateKeyLite;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPublicKeyEx;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefPublicKeyLite;
import com.sansec.devicev4.log.CryptoLogger;
import com.sansec.util.BigIntegers;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RSAHsmEngine
extends RSAEngine {
    private RSAKeyParameters key;
    private boolean forEncryption;
    private ISDSCrypto device;
    private Logger logger = CryptoLogger.logger;

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (RSAKeyParameters)rParam.getParameters();
        } else {
            this.key = (RSAKeyParameters)param;
        }
        this.forEncryption = forEncryption;
        try {
            this.device = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Get HSM device instance error", e);
        }
    }

    @Override
    public int getInputBlockSize() {
        int bitSize = this.key.getModulus().bitLength();
        if (this.forEncryption) {
            return (bitSize + 7) / 8 - 1;
        }
        return (bitSize + 7) / 8;
    }

    @Override
    public int getOutputBlockSize() {
        int bitSize = this.key.getModulus().bitLength();
        if (this.forEncryption) {
            return (bitSize + 7) / 8;
        }
        return (bitSize + 7) / 8 - 1;
    }

    @Override
    public byte[] convertInput(byte[] in, int inOff, int inLen) {
        byte[] block;
        if (inLen > this.getInputBlockSize() + 1) {
            throw new DataLengthException("input too large for RSA cipher.");
        }
        if (inLen == this.getInputBlockSize() + 1 && !this.forEncryption) {
            throw new DataLengthException("input too large for RSA cipher.");
        }
        if (in != null && (inOff != 0 || inLen != in.length)) {
            block = new byte[inLen];
            System.arraycopy(in, inOff, block, 0, inLen);
        } else {
            block = in;
        }
        if (this.forEncryption && block.length <= this.getInputBlockSize()) {
            byte[] tmp = new byte[this.getInputBlockSize() + 1];
            System.arraycopy(block, 0, tmp, tmp.length - block.length, block.length);
            return tmp;
        }
        return block;
    }

    @Override
    public byte[] convertOutput(byte[] output) {
        if (this.forEncryption) {
            if (output[0] == 0 && output.length > this.getOutputBlockSize()) {
                byte[] tmp = new byte[output.length - 1];
                System.arraycopy(output, 1, tmp, 0, tmp.length);
                return tmp;
            }
            if (output.length < this.getOutputBlockSize()) {
                byte[] tmp = new byte[this.getOutputBlockSize()];
                System.arraycopy(output, 0, tmp, tmp.length - output.length, output.length);
                return tmp;
            }
        } else if (output[0] == 0) {
            byte[] tmp = new byte[output.length - 1];
            System.arraycopy(output, 1, tmp, 0, tmp.length);
            return tmp;
        }
        return output;
    }

    @Override
    public byte[] processBlock(byte[] input) {
        int keyIndex = this.key.getKeyIndex();
        int keyType = this.key.getKeyType();
        String keyLabel = this.key.getKeyLabel();
        if (keyIndex > 0) {
            if (this.key instanceof RSAPrivateCrtKeyParameters) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Internal RSA private key operation\uff0ckeyIndex=" + keyIndex + ",keyType=" + keyType);
                }
                try {
                    return this.device.rsaPrivateKeyOperation(keyIndex, keyType, input);
                }
                catch (CryptoException e) {
                    throw new RuntimeCryptoException("Internal RSA private key operation error", e);
                }
            }
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, "Internal RSA public key operation\uff0ckeyIndex=" + keyIndex + ",keyType=" + keyType);
            }
            try {
                return this.device.rsaPublicKeyOperation(keyIndex, keyType, input);
            }
            catch (CryptoException e) {
                throw new RuntimeCryptoException("Internal RSA public key operation error", e);
            }
        }
        if (keyLabel != null && keyLabel.length() > 0) {
            if (this.key instanceof RSAPrivateCrtKeyParameters) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "Internal RSA private key operation\uff0ckeyLabel=" + keyLabel);
                }
                try {
                    return this.device.rsaPrivateKeyOperation(keyLabel, input);
                }
                catch (CryptoException e) {
                    throw new RuntimeCryptoException("Internal RSA private key operation error", e);
                }
            }
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, "Internal RSA public key operation\uff0ckeyLabel=" + keyLabel);
            }
            try {
                return this.device.rsaPublicKeyOperation(keyLabel, input);
            }
            catch (CryptoException e) {
                throw new RuntimeCryptoException("Internal RSA public key operation error", e);
            }
        }
        if (this.key instanceof RSAPrivateCrtKeyParameters) {
            RSAPrivateCrtKeyParameters k = (RSAPrivateCrtKeyParameters)this.key;
            RSArefPrivateKeyEx privateKey = null;
            byte[] n = BigIntegers.asUnsignedByteArray(k.getModulus());
            byte[] e = k.getPublicExponent().toByteArray();
            byte[] d = k.getExponent().toByteArray();
            byte[] p1 = k.getP().toByteArray();
            byte[] p2 = k.getQ().toByteArray();
            byte[] q1 = k.getDP().toByteArray();
            byte[] q2 = k.getDQ().toByteArray();
            byte[] coef = k.getQInv().toByteArray();
            if (k.getModulus().bitLength() > 2048) {
                privateKey = new RSArefPrivateKeyEx(n, e, d, p1, p2, q1, q2, coef);
                this.logger.fine(privateKey.toString());
            } else {
                privateKey = new RSArefPrivateKeyLite(n, e, d, p1, p2, q1, q2, coef);
                this.logger.fine(privateKey.toString());
            }
            try {
                return this.device.rsaPrivateKeyOperation((IRSArefPrivateKey)privateKey, input);
            }
            catch (CryptoException ex) {
                throw new RuntimeCryptoException("External RSA private key operation error", ex);
            }
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "External RSA public key operation");
        }
        RSAKeyParameters k = this.key;
        Object publicKey = null;
        byte[] n = BigIntegers.asUnsignedByteArray(k.getModulus());
        byte[] e = k.getExponent().toByteArray();
        int bits = k.getModulus().bitLength();
        publicKey = bits > 2048 ? new RSArefPublicKeyEx(bits, n, e) : new RSArefPublicKeyLite(bits, n, e);
        try {
            return this.device.rsaPublicKeyOperation((IRSArefPublicKey)publicKey, input);
        }
        catch (CryptoException ex) {
            throw new RuntimeCryptoException("External RSA public key operation error:", ex);
        }
    }
}

