/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.engines;

import com.sansec.asn1.pkcs.SM2CipherStructure;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.engines.SM2Soft;
import com.sansec.crypto.params.ParametersWithRandom;
import com.sansec.crypto.params.SM2KeyParameters;
import com.sansec.crypto.params.SM2PrivateKeyParameters;
import com.sansec.util.BigIntegerUitl;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidParameterException;

public class SM2Engine {
    private static final int CIPHER_LENGTH = 248;
    private static final int PLAIN_LENGTH = 136;
    protected SM2KeyParameters key;
    protected boolean forEncryption;

    public void init(boolean forEncryption, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (SM2KeyParameters)rParam.getParameters();
        } else {
            this.key = (SM2KeyParameters)param;
        }
        if (this.key.getKeyIndex() != 0 && this.key.getKeyType() != 0) {
            throw new InvalidParameterException("not support internal key");
        }
        this.forEncryption = forEncryption;
    }

    public int getInputBlockSize() {
        if (this.forEncryption) {
            return 136;
        }
        return 248;
    }

    public int getOutputBlockSize() {
        if (this.forEncryption) {
            return 248;
        }
        return 136;
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        if (this.key == null) {
            throw new IllegalStateException("SM2 engine not initialised");
        }
        SM2Soft device = new SM2Soft();
        byte[] out = null;
        byte[] dataInput = new byte[inLen];
        System.arraycopy(in, inOff, dataInput, 0, inLen);
        if (this.key instanceof SM2PrivateKeyParameters) {
            int keyIndex = this.key.getKeyIndex();
            if (keyIndex != 0) {
                throw new RuntimeCryptoException("Unsupport internal operation");
            }
            SM2CipherStructure structure = SM2CipherStructure.getInstance(dataInput);
            byte[] cipherData = new byte[96 + structure.getC().length];
            byte[] x = BigIntegerUitl.asUnsigned32ByteArray(structure.getX());
            byte[] y = BigIntegerUitl.asUnsigned32ByteArray(structure.getY());
            byte[] m = structure.getM();
            byte[] c = structure.getC();
            System.arraycopy(x, 0, cipherData, 0, 32);
            System.arraycopy(y, 0, cipherData, 32, 32);
            System.arraycopy(c, 0, cipherData, 64, c.length);
            System.arraycopy(m, 0, cipherData, 64 + c.length, 32);
            SM2PrivateKeyParameters keyParam = (SM2PrivateKeyParameters)this.key;
            byte[] d = BigIntegerUitl.asUnsigned32ByteArray(keyParam.getD());
            try {
                out = device.decrypt(d, cipherData);
            }
            catch (Exception e) {
                throw new RuntimeCryptoException(e);
            }
            return out;
        }
        SM2KeyParameters keyParam = this.key;
        byte[] x = BigIntegerUitl.asUnsigned32ByteArray(keyParam.getX());
        byte[] y = BigIntegerUitl.asUnsigned32ByteArray(keyParam.getY());
        byte[] bPubKey = new byte[64];
        System.arraycopy(x, 0, bPubKey, 0, 32);
        System.arraycopy(y, 0, bPubKey, 32, 32);
        byte[] cipherData = null;
        try {
            cipherData = device.encrypt(bPubKey, dataInput);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("SM2 encrypt error ", e);
        }
        byte[] X = new byte[32];
        byte[] Y = new byte[32];
        byte[] M = new byte[32];
        byte[] C = new byte[cipherData.length - 96];
        System.arraycopy(cipherData, 0, X, 0, 32);
        System.arraycopy(cipherData, 32, Y, 0, 32);
        System.arraycopy(cipherData, 64, C, 0, C.length);
        System.arraycopy(cipherData, 64 + C.length, M, 0, 32);
        SM2CipherStructure cipherSt = new SM2CipherStructure(new BigInteger(1, X), new BigInteger(1, Y), C, M);
        try {
            out = cipherSt.getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeCryptoException("Construct SM2 cipher error", e);
        }
        return out;
    }
}

