/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.engines;

import com.sansec.crypto.digests.SM3Digest;
import com.sansec.crypto.params.ECDomainParameters;
import com.sansec.math.ec.ECCurve;
import com.sansec.math.ec.ECPoint;
import com.sansec.util.BigIntegers;
import com.sansec.util.ByteUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;

public class SM2Soft {
    public static final BigInteger p = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
    public static final BigInteger a = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
    public static final BigInteger b = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
    public static final BigInteger n = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
    public static final BigInteger Gx = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    public static final BigInteger Gy = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    public static final BigInteger ZERO = BigInteger.valueOf(0L);
    public static final BigInteger ONE = BigInteger.valueOf(1L);
    private static ECPoint G = null;
    private static ECCurve sm2Curve = null;
    private static int w = (int)Math.ceil((double)n.bitLength() * 1.0 / 2.0) - 1;
    private static BigInteger _2w = new BigInteger("2").pow(w);
    private static SecureRandom random = new SecureRandom();
    private static ECDomainParameters ecc_bc_spec;

    public ECPoint createPoint(BigInteger x, BigInteger y) {
        return sm2Curve.createPoint(x, y);
    }

    public ECPoint decodePoint(byte[] encoded) {
        if (encoded.length == 64) {
            byte[] bX = new byte[32];
            byte[] bY = new byte[32];
            System.arraycopy(encoded, 0, bX, 0, 32);
            System.arraycopy(encoded, 32, bY, 0, 32);
            BigInteger x = new BigInteger(1, bX);
            BigInteger y = new BigInteger(1, bY);
            return this.createPoint(x, y);
        }
        return sm2Curve.decodePoint(encoded);
    }

    public static ECDomainParameters getEcc_bc_spec() {
        return ecc_bc_spec;
    }

    public static ECCurve getSm2Curve() {
        return sm2Curve;
    }

    public static ECPoint getG() {
        return G;
    }

    public byte[] generateKeyPair() {
        BigInteger d;
        int nBitLength = n.bitLength();
        while ((d = new BigInteger(nBitLength, new Random())).equals(BigInteger.valueOf(0L)) || d.compareTo(n) >= 0) {
        }
        ECPoint Q = G.multiply(d);
        byte[] key = new byte[96];
        byte[] bD = BigIntegers.asUnsignedByteArray(d);
        byte[] bX = BigIntegers.asUnsignedByteArray(Q.getX().toBigInteger());
        byte[] bY = BigIntegers.asUnsignedByteArray(Q.getY().toBigInteger());
        System.arraycopy(bD, 0, key, 32 - bD.length, bD.length);
        System.arraycopy(bX, 0, key, 64 - bX.length, bX.length);
        System.arraycopy(bY, 0, key, 96 - bY.length, bY.length);
        return key;
    }

    public byte[] encrypt(byte[] bPubKey, byte[] bMessage) {
        byte[] buf;
        BigInteger k = null;
        byte[] t = null;
        byte[] x2 = null;
        byte[] y2 = null;
        ECPoint C = null;
        do {
            int nBitLength = n.bitLength();
            while ((k = new BigInteger(nBitLength, new Random())).compareTo(ONE) < 0 || k.compareTo(n) >= 0) {
            }
            C = G.multiply(k);
            ECPoint Pb = this.decodePoint(bPubKey);
            BigInteger h = ((ECCurve.Fp)sm2Curve).getQ().divide(n);
            ECPoint S = Pb.multiply(h);
            ECPoint point = Pb.multiply(k);
            x2 = BigIntegers.asUnsignedByteArray(point.getX().toBigInteger());
            y2 = BigIntegers.asUnsignedByteArray(point.getY().toBigInteger());
            buf = new byte[64];
            System.arraycopy(x2, 0, buf, 32 - x2.length, x2.length);
            System.arraycopy(y2, 0, buf, 64 - y2.length, y2.length);
        } while (new BigInteger(t = SM2Soft.KDF(buf, bMessage.length)).equals(ZERO));
        byte[] C2 = this.XOR(bMessage, t);
        byte[] input = new byte[64 + bMessage.length];
        System.arraycopy(x2, 0, input, 32 - x2.length, x2.length);
        System.arraycopy(bMessage, 0, input, 32, bMessage.length);
        System.arraycopy(y2, 0, input, input.length - y2.length, y2.length);
        byte[] C3 = this.hash(input);
        byte[] bX = BigIntegers.asUnsignedByteArray(C.getX().toBigInteger());
        byte[] bY = BigIntegers.asUnsignedByteArray(C.getY().toBigInteger());
        int len = 96 + bMessage.length;
        byte[] out = new byte[len];
        System.arraycopy(bX, 0, out, 32 - bX.length, bX.length);
        System.arraycopy(bY, 0, out, 64 - bY.length, bY.length);
        System.arraycopy(C2, 0, out, 64, C2.length);
        System.arraycopy(C3, 0, out, len - C3.length, C3.length);
        return out;
    }

    public byte[] decrypt(byte[] bPriKey, byte[] bCipher) {
        int len = bCipher.length;
        byte[] bX = new byte[32];
        byte[] bY = new byte[32];
        byte[] bM = new byte[32];
        byte[] bC = new byte[len - 96];
        System.arraycopy(bCipher, 0, bX, 0, 32);
        System.arraycopy(bCipher, 32, bY, 0, 32);
        System.arraycopy(bCipher, 64, bC, 0, bC.length);
        System.arraycopy(bCipher, len - 32, bM, 0, 32);
        ECPoint C1 = this.createPoint(new BigInteger(1, bX), new BigInteger(1, bY));
        BigInteger dB = new BigInteger(1, bPriKey);
        ECPoint point = C1.multiply(dB);
        byte[] x2 = BigIntegers.asUnsignedByteArray(point.getX().toBigInteger());
        byte[] y2 = BigIntegers.asUnsignedByteArray(point.getY().toBigInteger());
        byte[] buf = new byte[64];
        System.arraycopy(x2, 0, buf, 32 - x2.length, x2.length);
        System.arraycopy(y2, 0, buf, 64 - y2.length, y2.length);
        byte[] C2 = bC;
        byte[] t = SM2Soft.KDF(buf, C2.length);
        if (new BigInteger(t).equals(ZERO)) {
            throw new RuntimeException("count t=KDF(x2||y2, klen),result is0");
        }
        byte[] message = this.XOR(C2, t);
        byte[] input = new byte[64 + message.length];
        System.arraycopy(x2, 0, input, 32 - x2.length, x2.length);
        System.arraycopy(message, 0, input, 32, message.length);
        System.arraycopy(y2, 0, input, input.length - y2.length, y2.length);
        byte[] u = this.hash(input);
        byte[] C3 = bM;
        if (Arrays.equals(u, C3)) {
            return message;
        }
        throw new RuntimeException("Hash result not equal.");
    }

    private byte[] hash(byte[] input) {
        SM3Digest digest = new SM3Digest();
        digest.update(input, 0, input.length);
        byte[] sm3 = new byte[32];
        digest.doFinal(sm3, 0);
        return sm3;
    }

    private byte[] XOR(byte[] x, byte[] y) {
        byte[] z = new byte[x.length];
        for (int i = 0; i < z.length; ++i) {
            z[i] = (byte)(x[i] ^ y[i]);
        }
        return z;
    }

    private static byte[] KDF(byte[] Z, int klen) {
        int blockSize = 32;
        int outLen = klen % blockSize == 0 ? klen : (klen / blockSize + 1) * blockSize;
        byte[] out = new byte[outLen];
        int ct = 1;
        SM3Digest sm3 = null;
        byte[] hash = null;
        byte[] buf = null;
        int outOffset = 0;
        for (int i = 0; i < outLen / blockSize; ++i) {
            sm3 = new SM3Digest();
            buf = SM2Soft.byteArrayCat(Z, SM2Soft.int2bytes(ct));
            sm3.update(buf, 0, buf.length);
            hash = new byte[32];
            sm3.doFinal(hash, 0);
            System.arraycopy(hash, 0, out, outOffset, hash.length);
            outOffset += hash.length;
            ++ct;
        }
        return out;
    }

    private static byte[] byteArrayCat(byte[] x, byte[] y) {
        byte[] out = new byte[x.length + y.length];
        System.arraycopy(x, 0, out, 0, x.length);
        System.arraycopy(y, 0, out, x.length, y.length);
        return out;
    }

    private static byte[] int2bytes(int num) {
        return ByteUtil.int2bytes(num);
    }

    public byte[] sign(byte[] bPriKey, byte[] bHash) {
        BigInteger k;
        BigInteger d;
        if (bPriKey == null) {
            throw new RuntimeException("Private key is null");
        }
        if (bPriKey.length != 32) {
            throw new RuntimeException("Private Key length: " + bPriKey.length * 8 + "bits");
        }
        if (bHash == null) {
            throw new RuntimeException("Hash is null");
        }
        if (bHash.length != 32) {
            throw new RuntimeException("Hash length: " + bHash.length * 8 + "bits");
        }
        BigInteger e = new BigInteger(1, bHash);
        BigInteger r = null;
        BigInteger s = null;
        do {
            ECPoint p;
            BigInteger x;
            k = null;
            int nBitLength = n.bitLength();
            while ((k = new BigInteger(nBitLength, new Random())).equals(ZERO) || (r = e.add(x = (p = G.multiply(k)).getX().toBigInteger()).mod(n)).equals(ZERO) || r.add(k).equals(n)) {
            }
        } while ((s = ONE.add(d = new BigInteger(1, bPriKey)).modInverse(n).multiply(k.subtract(d.multiply(r))).mod(n)).equals(ZERO));
        BigInteger[] res = new BigInteger[]{r, s};
        byte[] bR = BigIntegers.asUnsignedByteArray(r);
        byte[] bS = BigIntegers.asUnsignedByteArray(s);
        byte[] signature = new byte[64];
        System.arraycopy(bR, 0, signature, 32 - bR.length, bR.length);
        System.arraycopy(bS, 0, signature, 64 - bS.length, bS.length);
        return signature;
    }

    public boolean verify(byte[] bPubKey, byte[] bHash, byte[] bSignature) {
        if (bPubKey == null) {
            throw new RuntimeException("Public key is null");
        }
        if (bPubKey.length != 64) {
            throw new RuntimeException("Public Key length: " + bPubKey.length * 8 + "bits");
        }
        if (bHash == null) {
            throw new RuntimeException("Hash is null");
        }
        if (bHash.length != 32) {
            throw new RuntimeException("Invalid Hash length: " + bHash.length * 8 + "bits");
        }
        BigInteger e = new BigInteger(1, bHash);
        byte[] bR = new byte[32];
        byte[] bS = new byte[32];
        System.arraycopy(bSignature, 0, bR, 0, 32);
        System.arraycopy(bSignature, 32, bS, 0, 32);
        BigInteger r = new BigInteger(1, bR);
        BigInteger s = new BigInteger(1, bS);
        byte[] bX = new byte[32];
        byte[] bY = new byte[32];
        System.arraycopy(bPubKey, 0, bX, 0, 32);
        System.arraycopy(bPubKey, 32, bY, 0, 32);
        BigInteger x = new BigInteger(1, bX);
        BigInteger y = new BigInteger(1, bY);
        if (r.compareTo(ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(ONE) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        BigInteger t = r.add(s).mod(n);
        if (t.equals(ZERO)) {
            return false;
        }
        ECPoint P = this.createPoint(x, y);
        ECPoint T = G.multiply(s).add(P.multiply(t));
        BigInteger R = e.add(T.getX().toBigInteger()).mod(n);
        return R.equals(r);
    }

    private static byte[] join(byte[] ... params) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] res = null;
        try {
            for (int i = 0; i < params.length; ++i) {
                baos.write(params[i]);
            }
            res = baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    private static byte[] sm3hash(byte[] ... params) {
        byte[] data = SM2Soft.join(params);
        byte[] res = new byte[32];
        SM3Digest sm3 = new SM3Digest();
        sm3.update(data, 0, data.length);
        sm3.doFinal(res, 0);
        return res;
    }

    private static BigInteger random(BigInteger max) {
        BigInteger r = new BigInteger(256, random);
        while (r.compareTo(max) >= 0) {
            r = new BigInteger(128, random);
        }
        return r;
    }

    private static byte[] ZA(String IDA, ECPoint aPublicKey) {
        byte[] idaBytes = IDA.getBytes();
        int entlenA = idaBytes.length * 8;
        byte[] ENTLA = new byte[]{(byte)(entlenA & 0xFF00), (byte)(entlenA & 0xFF)};
        byte[] ZA = SM2Soft.sm3hash(ENTLA, idaBytes, a.toByteArray(), b.toByteArray(), Gx.toByteArray(), Gy.toByteArray(), aPublicKey.getXCoord().toBigInteger().toByteArray(), aPublicKey.getYCoord().toBigInteger().toByteArray());
        return ZA;
    }

    static {
        sm2Curve = new ECCurve.Fp(p, a, b);
        G = sm2Curve.createPoint(Gx, Gy);
        ecc_bc_spec = new ECDomainParameters(sm2Curve, G, n);
    }

    public static class KeyExchange {
        BigInteger rA;
        ECPoint RA;
        ECPoint V;
        byte[] Z;
        byte[] key;
        String ID;
        SM2KeyPair keyPair;

        public KeyExchange(String ID, SM2KeyPair keyPair) {
            this.ID = ID;
            this.keyPair = keyPair;
            this.Z = SM2Soft.ZA(ID, keyPair.getPublicKey());
        }

        public TransportEntity keyExchange_1() {
            this.rA = SM2Soft.random(n);
            this.RA = G.multiply(this.rA).normalize();
            return new TransportEntity(this.RA.getEncoded(false), null, this.Z, this.keyPair.getPublicKey());
        }

        public TransportEntity keyExchange_2(TransportEntity entity) {
            BigInteger rB = SM2Soft.random(n);
            ECPoint RB = G.multiply(rB).normalize();
            this.rA = rB;
            this.RA = RB;
            BigInteger x2 = RB.getXCoord().toBigInteger();
            x2 = _2w.add(x2.and(_2w.subtract(BigInteger.ONE)));
            BigInteger tB = this.keyPair.getPrivateKey().add(x2.multiply(rB)).mod(n);
            ECPoint RA = sm2Curve.decodePoint(entity.R).normalize();
            BigInteger x1 = RA.getXCoord().toBigInteger();
            x1 = _2w.add(x1.and(_2w.subtract(BigInteger.ONE)));
            ECPoint aPublicKey = sm2Curve.decodePoint(entity.K).normalize();
            ECPoint temp = aPublicKey.add(RA.multiply(x1).normalize()).normalize();
            ECPoint V = temp.multiply(ecc_bc_spec.getH().multiply(tB)).normalize();
            if (V.isInfinity()) {
                throw new IllegalStateException();
            }
            this.V = V;
            byte[] xV = V.getXCoord().toBigInteger().toByteArray();
            byte[] yV = V.getYCoord().toBigInteger().toByteArray();
            byte[] KB = SM2Soft.KDF(SM2Soft.join(new byte[][]{xV, yV, entity.Z, this.Z}), 16);
            this.key = KB;
            byte[] sB = SM2Soft.sm3hash(new byte[][]{{2}, yV, SM2Soft.sm3hash(new byte[][]{xV, entity.Z, this.Z, RA.getXCoord().toBigInteger().toByteArray(), RA.getYCoord().toBigInteger().toByteArray(), RB.getXCoord().toBigInteger().toByteArray(), RB.getYCoord().toBigInteger().toByteArray()})});
            return new TransportEntity(RB.getEncoded(false), sB, this.Z, this.keyPair.getPublicKey());
        }

        public TransportEntity keyExchange_3(TransportEntity entity) {
            BigInteger x1 = this.RA.getXCoord().toBigInteger();
            x1 = _2w.add(x1.and(_2w.subtract(BigInteger.ONE)));
            BigInteger tA = this.keyPair.getPrivateKey().add(x1.multiply(this.rA)).mod(n);
            ECPoint RB = sm2Curve.decodePoint(entity.R).normalize();
            BigInteger x2 = RB.getXCoord().toBigInteger();
            x2 = _2w.add(x2.and(_2w.subtract(BigInteger.ONE)));
            ECPoint bPublicKey = sm2Curve.decodePoint(entity.K).normalize();
            ECPoint temp = bPublicKey.add(RB.multiply(x2).normalize()).normalize();
            ECPoint U = temp.multiply(ecc_bc_spec.getH().multiply(tA)).normalize();
            if (U.isInfinity()) {
                throw new IllegalStateException();
            }
            this.V = U;
            byte[] xU = U.getXCoord().toBigInteger().toByteArray();
            byte[] yU = U.getYCoord().toBigInteger().toByteArray();
            byte[] KA = SM2Soft.KDF(SM2Soft.join(new byte[][]{xU, yU, this.Z, entity.Z}), 16);
            this.key = KA;
            byte[] s1 = SM2Soft.sm3hash(new byte[][]{{2}, yU, SM2Soft.sm3hash(new byte[][]{xU, this.Z, entity.Z, this.RA.getXCoord().toBigInteger().toByteArray(), this.RA.getYCoord().toBigInteger().toByteArray(), RB.getXCoord().toBigInteger().toByteArray(), RB.getYCoord().toBigInteger().toByteArray()})});
            if (Arrays.equals(entity.S, s1)) {
                System.out.println("B->A \u5bc6\u94a5\u786e\u8ba4\u6210\u529f");
            } else {
                System.out.println("B->A \u5bc6\u94a5\u786e\u8ba4\u5931\u8d25");
            }
            byte[] sA = SM2Soft.sm3hash(new byte[][]{{3}, yU, SM2Soft.sm3hash(new byte[][]{xU, this.Z, entity.Z, this.RA.getXCoord().toBigInteger().toByteArray(), this.RA.getYCoord().toBigInteger().toByteArray(), RB.getXCoord().toBigInteger().toByteArray(), RB.getYCoord().toBigInteger().toByteArray()})});
            return new TransportEntity(this.RA.getEncoded(false), sA, this.Z, this.keyPair.getPublicKey());
        }

        public void keyExchange_4(TransportEntity entity) {
            byte[] xV = this.V.getXCoord().toBigInteger().toByteArray();
            byte[] yV = this.V.getYCoord().toBigInteger().toByteArray();
            ECPoint RA = sm2Curve.decodePoint(entity.R).normalize();
            byte[] s2 = SM2Soft.sm3hash(new byte[][]{{3}, yV, SM2Soft.sm3hash(new byte[][]{xV, entity.Z, this.Z, RA.getXCoord().toBigInteger().toByteArray(), RA.getYCoord().toBigInteger().toByteArray(), this.RA.getXCoord().toBigInteger().toByteArray(), this.RA.getYCoord().toBigInteger().toByteArray()})});
            if (Arrays.equals(entity.S, s2)) {
                System.out.println("A->B \u5bc6\u94a5\u786e\u8ba4\u6210\u529f");
            } else {
                System.out.println("A->B \u5bc6\u94a5\u786e\u8ba4\u5931\u8d25");
            }
        }
    }

    public class SM2KeyPair {
        private final ECPoint publicKey;
        private final BigInteger privateKey;

        SM2KeyPair(ECPoint publicKey, BigInteger privateKey) {
            this.publicKey = publicKey;
            this.privateKey = privateKey;
        }

        public ECPoint getPublicKey() {
            return this.publicKey;
        }

        public BigInteger getPrivateKey() {
            return this.privateKey;
        }
    }

    private static class TransportEntity
    implements Serializable {
        final byte[] R;
        final byte[] S;
        final byte[] Z;
        final byte[] K;

        public TransportEntity(byte[] r, byte[] s, byte[] z, ECPoint pKey) {
            this.R = r;
            this.S = s;
            this.Z = z;
            this.K = pKey.getEncoded(false);
        }
    }
}

