/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.generators;

import com.sansec.crypto.AsymmetricCipherKeyPair;
import com.sansec.crypto.KeyGenerationParameters;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.generators.DSAKeyPairGenerator;
import com.sansec.crypto.params.DSAKeyGenerationParameters;
import com.sansec.crypto.params.DSAParameters;
import com.sansec.crypto.params.DSAPrivateKeyParameters;
import com.sansec.crypto.params.DSAPublicKeyParameters;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.IDSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.IDSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.dsa.DSArefKeyPair;
import com.sansec.util.BigIntegerUitl;
import com.sansec.util.KeyIndexUtil;
import java.math.BigInteger;

public class DSAHsmKeyPairGenerator
extends DSAKeyPairGenerator {
    private DSAKeyGenerationParameters param;

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        int strength = this.param.getStrength();
        ISDSCrypto device = null;
        try {
            device = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Get HSM device instance error", e);
        }
        if (strength >= 65536) {
            IDSArefPublicKey publicKey;
            int exIndex = strength >> 16;
            KeyIndexUtil.KeyIndexStruct struct = null;
            try {
                struct = KeyIndexUtil.parse2KeyIndex(exIndex);
            }
            catch (Exception e) {
                throw new RuntimeCryptoException("Trans key index error", e);
            }
            int keyIndex = struct.keyIndex;
            int keyType = struct.keyType;
            Object e = null;
            Object n = null;
            try {
                publicKey = device.getDSAPublicKey(keyIndex, keyType);
            }
            catch (Exception ex) {
                throw new RuntimeCryptoException("Get internal DSA public key error", ex);
            }
            byte[] pBytes = publicKey.getP();
            byte[] qBytes = publicKey.getQ();
            byte[] gBytes = publicKey.getG();
            byte[] pubkeyBytes = publicKey.getPubkey();
            BigInteger p = BigIntegerUitl.toPositiveInteger(pBytes);
            BigInteger q = BigIntegerUitl.toPositiveInteger(qBytes);
            BigInteger g = BigIntegerUitl.toPositiveInteger(gBytes);
            DSAParameters dsaParams = new DSAParameters(p, q, g);
            BigInteger pub = BigIntegerUitl.toPositiveInteger(pubkeyBytes);
            BigInteger x = new BigInteger(exIndex + "");
            return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(keyIndex, keyType, publicKey.getBits(), pub, dsaParams), new DSAPrivateKeyParameters(keyIndex, keyType, publicKey.getBits(), x, dsaParams));
        }
        DSArefKeyPair keyPair = null;
        try {
            keyPair = device.generateDSAKeyPair(strength);
        }
        catch (Exception ex) {
            throw new RuntimeCryptoException("Generate DSA key pair error", ex);
        }
        IDSArefPrivateKey privateKey = keyPair.getPrivateKey();
        byte[] pBytes = privateKey.getP();
        byte[] qBytes = privateKey.getQ();
        byte[] gBytes = privateKey.getG();
        byte[] pubkeyBytes = privateKey.getPubkey();
        byte[] privkeyBytes = privateKey.getPrivkey();
        BigInteger p = BigIntegerUitl.toPositiveInteger(pBytes);
        BigInteger q = BigIntegerUitl.toPositiveInteger(qBytes);
        BigInteger g = BigIntegerUitl.toPositiveInteger(gBytes);
        DSAParameters dsaParams = new DSAParameters(p, q, g);
        BigInteger pub = BigIntegerUitl.toPositiveInteger(pubkeyBytes);
        BigInteger pri = BigIntegerUitl.toPositiveInteger(privkeyBytes);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(privateKey.getBits(), pub, dsaParams), new DSAPrivateKeyParameters(privateKey.getBits(), pri, dsaParams));
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DSAKeyGenerationParameters)param;
    }
}

