/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.generators;

import com.sansec.asn1.ASN1ObjectIdentifier;
import com.sansec.asn1.x9.ECNamedCurveTable;
import com.sansec.asn1.x9.X9ECParameters;
import com.sansec.crypto.AsymmetricCipherKeyPair;
import com.sansec.crypto.KeyGenerationParameters;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.generators.ECKeyPairGenerator;
import com.sansec.crypto.params.ECDomainParameters;
import com.sansec.crypto.params.ECKeyGenerationParameters;
import com.sansec.crypto.params.ECPrivateKeyParameters;
import com.sansec.crypto.params.ECPublicKeyParameters;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefKeyPair;
import com.sansec.devicev4.gb.struct.key.ecdsa.ECDSArefPublicKey;
import com.sansec.jcajce.provider.asymmetric.ec.ECUtils;
import com.sansec.jcajce.provider.asymmetric.util.EC5Util;
import com.sansec.jce.spec.ECNamedCurveSpec;
import com.sansec.math.ec.ECCurve;
import com.sansec.math.ec.ECMultiplier;
import com.sansec.math.ec.ECPoint;
import com.sansec.math.ec.FixedPointCombMultiplier;
import com.sansec.util.BigIntegerUitl;
import com.sansec.util.KeyIndexUtil;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.ECParameterSpec;

public class ECHsmKeyPairGenerator
extends ECKeyPairGenerator {
    public ECKeyGenerationParameters keyGenerationParameters;

    @Override
    public void init(KeyGenerationParameters param) {
        ECKeyGenerationParameters ecP;
        this.keyGenerationParameters = ecP = (ECKeyGenerationParameters)param;
        this.random = ecP.getRandom();
        this.params = ecP.getDomainParameters();
        this.strength = ecP.getStrength();
        if (this.random == null) {
            this.random = new SecureRandom();
        }
    }

    protected ECNamedCurveSpec createNamedCurveSpec(String curveName) throws InvalidAlgorithmParameterException {
        X9ECParameters p = ECUtils.getDomainParametersFromName(curveName);
        if (p == null) {
            try {
                p = ECNamedCurveTable.getByOID(new ASN1ObjectIdentifier(curveName));
                if (p == null) {
                    throw new InvalidAlgorithmParameterException("unknown curve OID: " + curveName);
                }
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidAlgorithmParameterException("unknown curve name: " + curveName);
            }
        }
        byte[] seed = null;
        return new ECNamedCurveSpec(curveName, p.getCurve(), p.getG(), p.getN(), p.getH(), seed);
    }

    protected ECKeyGenerationParameters createKeyGenParamsJCE(ECParameterSpec p, SecureRandom r) {
        ECCurve curve = EC5Util.convertCurve(p.getCurve());
        ECPoint g = EC5Util.convertPoint(curve, p.getGenerator());
        BigInteger n = p.getOrder();
        BigInteger h = BigInteger.valueOf(p.getCofactor());
        ECDomainParameters dp = new ECDomainParameters(curve, g, n, h);
        return new ECKeyGenerationParameters(dp, r);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger d = null;
        ECPoint Q = null;
        ISDSCrypto device = null;
        try {
            device = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Get HSM device instance error", e);
        }
        if (this.strength >= 65536) {
            ECDSArefPublicKey publicKey;
            int index = this.strength >> 16;
            KeyIndexUtil.KeyIndexStruct struct = null;
            try {
                struct = KeyIndexUtil.parse2KeyIndex(index);
            }
            catch (Exception e) {
                throw new RuntimeCryptoException("Trans key index error", e);
            }
            int keyIndex = struct.keyIndex;
            int keyType = struct.keyType;
            try {
                publicKey = device.getECDSAPublicKey(keyIndex, keyType);
            }
            catch (Exception ex) {
                throw new RuntimeCryptoException("Get ECDSA public key error", ex);
            }
            BigInteger x = BigIntegerUitl.toPositiveInteger(publicKey.getX());
            BigInteger y = BigIntegerUitl.toPositiveInteger(publicKey.getY());
            int bits = publicKey.getBits();
            int cureType = publicKey.getCurvetype();
            String curveName = ECUtils.getCurveTypeName(cureType, bits);
            try {
                ECNamedCurveSpec ecNamedCurveSpec = this.createNamedCurveSpec(curveName);
                ECKeyGenerationParameters ecKeyGenerationParameters = this.createKeyGenParamsJCE(ecNamedCurveSpec, this.random);
                this.params = ecKeyGenerationParameters.getDomainParameters();
            }
            catch (InvalidAlgorithmParameterException e) {
                e.printStackTrace();
            }
            d = new BigInteger(index + "");
            java.security.spec.ECPoint g = new java.security.spec.ECPoint(x, y);
            Q = EC5Util.convertPoint(this.params.getCurve(), g);
            return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(keyIndex, keyType, bits, cureType, Q, this.params), new ECPrivateKeyParameters(keyIndex, keyType, bits, cureType, d, this.params));
        }
        String curveTypeeName = this.keyGenerationParameters.getCurveType();
        int cureType = ECUtils.getCurveType(curveTypeeName);
        ECDSArefKeyPair ecdsArefKeyPair = null;
        try {
            ecdsArefKeyPair = device.generateECDSAKeyPair(this.strength, cureType);
        }
        catch (CryptoException e) {
            throw new RuntimeCryptoException("generateECDSAKeyPair(keysize, curetype) error: ", e);
        }
        int bits = ecdsArefKeyPair.getPrivateKey().getBits();
        d = BigIntegerUitl.toPositiveInteger(ecdsArefKeyPair.getPrivateKey().getD());
        BigInteger x = BigIntegerUitl.toPositiveInteger(ecdsArefKeyPair.getPublicKey().getX());
        BigInteger y = BigIntegerUitl.toPositiveInteger(ecdsArefKeyPair.getPublicKey().getY());
        java.security.spec.ECPoint g = new java.security.spec.ECPoint(x, y);
        Q = EC5Util.convertPoint(this.params.getCurve(), g);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(bits, cureType, Q, this.params), new ECPrivateKeyParameters(bits, cureType, d, this.params));
    }

    @Override
    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

