/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.generators;

import com.sansec.crypto.AsymmetricCipherKeyPair;
import com.sansec.crypto.AsymmetricCipherKeyPairGenerator;
import com.sansec.crypto.KeyGenerationParameters;
import com.sansec.crypto.params.ECDomainParameters;
import com.sansec.crypto.params.ECKeyGenerationParameters;
import com.sansec.crypto.params.ECPrivateKeyParameters;
import com.sansec.crypto.params.ECPublicKeyParameters;
import com.sansec.math.ec.ECConstants;
import com.sansec.math.ec.ECMultiplier;
import com.sansec.math.ec.ECPoint;
import com.sansec.math.ec.FixedPointCombMultiplier;
import com.sansec.math.ec.WNafUtil;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.SecureRandom;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;
    int strength;

    @Override
    public void init(KeyGenerationParameters param) {
        ECKeyGenerationParameters ecP = (ECKeyGenerationParameters)param;
        this.random = ecP.getRandom();
        this.params = ecP.getDomainParameters();
        this.strength = ecP.getStrength();
        if (this.strength >= 65536) {
            throw new InvalidParameterException("key too long error");
        }
        if (this.random == null) {
            this.random = new SecureRandom();
        }
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger n = this.params.getN();
        int nBitLength = n.bitLength();
        BigInteger d = null;
        ECPoint Q = null;
        int minWeight = nBitLength >>> 2;
        while ((d = new BigInteger(nBitLength, this.random)).compareTo(TWO) < 0 || d.compareTo(n) >= 0 || WNafUtil.getNafWeight(d) < minWeight) {
        }
        Q = this.createBasePointMultiplier().multiply(this.params.getG(), d);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(Q, this.params), new ECPrivateKeyParameters(d, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

