/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.generators;

import com.sansec.crypto.AsymmetricCipherKeyPair;
import com.sansec.crypto.AsymmetricCipherKeyPairGenerator;
import com.sansec.crypto.KeyGenerationParameters;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.params.Ed25519PrivateKeyParameters;
import com.sansec.crypto.params.Ed25519PublicKeyParameters;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.ed.EdDSArefKeyPair;
import com.sansec.devicev4.gb.struct.key.ed.EdDSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.ed.EdDSArefPublicKey;
import com.sansec.devicev4.util.BytesUtil;
import com.sansec.util.KeyIndexUtil;
import java.security.SecureRandom;

public class Ed25519HsmKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;
    private int keyStrength;

    @Override
    public void init(KeyGenerationParameters parameters) {
        this.random = parameters.getRandom();
        this.keyStrength = parameters.getStrength();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        ISDSCrypto device = null;
        try {
            device = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Get HSM device instance error", e);
        }
        if (this.keyStrength >= 65536) {
            EdDSArefPublicKey publicKey;
            int index = this.keyStrength >> 16;
            KeyIndexUtil.KeyIndexStruct struct = null;
            try {
                struct = KeyIndexUtil.parse2KeyIndex(index);
            }
            catch (Exception e) {
                throw new RuntimeCryptoException("Trans key index error", e);
            }
            int keyIndex = struct.keyIndex;
            int keyType = struct.keyType;
            try {
                publicKey = device.getEdDSAPublicKey(keyIndex, keyType);
            }
            catch (Exception ex) {
                throw new RuntimeCryptoException("Get EdDSA public key error", ex);
            }
            byte[] indexBytes = BytesUtil.int2bytes((int)index);
            return new AsymmetricCipherKeyPair(new Ed25519PublicKeyParameters(keyIndex, keyType, 256, false, BytesUtil.subbytes((byte[])publicKey.getA(), (int)47, (int)32), 0), new Ed25519PrivateKeyParameters(keyIndex, keyType, 256, false, indexBytes, 0));
        }
        int cureType = 1;
        EdDSArefKeyPair eddsArefKeyPair = null;
        try {
            eddsArefKeyPair = device.generateEdDSAKeyPair(256, cureType);
        }
        catch (CryptoException e) {
            throw new RuntimeCryptoException("generateEdDSAKeyPair(keysize, curetype) error: ", e);
        }
        EdDSArefPublicKey publicKey = eddsArefKeyPair.getPublicKey();
        EdDSArefPrivateKey privateKey = eddsArefKeyPair.getPrivateKey();
        byte[] A = BytesUtil.subbytes((byte[])publicKey.getA(), (int)48, (int)32);
        byte[] K = BytesUtil.subbytes((byte[])privateKey.getK(), (int)48, (int)32);
        return new AsymmetricCipherKeyPair(new Ed25519PublicKeyParameters(A, 0), new Ed25519PrivateKeyParameters(K, 0));
    }
}

