/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.generators;

import com.sansec.crypto.AsymmetricCipherKeyPair;
import com.sansec.crypto.AsymmetricCipherKeyPairGenerator;
import com.sansec.crypto.KeyGenerationParameters;
import com.sansec.crypto.params.Ed448PrivateKeyParameters;
import com.sansec.crypto.params.Ed448PublicKeyParameters;
import java.security.SecureRandom;

public class Ed448KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters parameters) {
        this.random = parameters.getRandom();
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        Ed448PrivateKeyParameters privateKey = new Ed448PrivateKeyParameters(this.random);
        Ed448PublicKeyParameters publicKey = privateKey.generatePublicKey();
        return new AsymmetricCipherKeyPair(publicKey, privateKey);
    }
}

