/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.generators;

import com.sansec.crypto.AsymmetricCipherKeyPair;
import com.sansec.crypto.KeyGenerationParameters;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.generators.RSAKeyPairGenerator;
import com.sansec.crypto.params.RSAKeyGenerationParameters;
import com.sansec.crypto.params.RSAKeyParameters;
import com.sansec.crypto.params.RSAPrivateCrtKeyParameters;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.IRSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.IRSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.rsa.RSArefKeyPair;
import com.sansec.util.BigIntegerUitl;
import com.sansec.util.KeyIndexUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

public class RSAHsmKeyPairGenerator
extends RSAKeyPairGenerator {
    private RSAKeyGenerationParameters param;

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        int strength = this.param.getStrength();
        BigInteger exponent = this.param.getPublicExponent();
        ISDSCrypto device = null;
        try {
            device = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Get HSM device instance error", e);
        }
        if (strength >= 65536) {
            IRSArefPublicKey publicKey;
            int exIndex = strength >> 16;
            KeyIndexUtil.KeyIndexStruct struct = null;
            try {
                struct = KeyIndexUtil.parse2KeyIndex(exIndex);
            }
            catch (Exception e) {
                throw new RuntimeCryptoException("Trans key index error", e);
            }
            int keyIndex = struct.keyIndex;
            int keyType = struct.keyType;
            BigInteger e = null;
            BigInteger n = null;
            try {
                publicKey = device.getRSAPublicKey(keyIndex, keyType);
                e = BigIntegerUitl.toPositiveInteger(publicKey.getE());
                n = BigIntegerUitl.toPositiveInteger(publicKey.getM());
            }
            catch (Exception ex) {
                throw new RuntimeCryptoException("Get internal RSA public key error", ex);
            }
            BigInteger d = new BigInteger(exIndex + "");
            BigInteger p1 = null;
            BigInteger p2 = null;
            BigInteger q1 = null;
            BigInteger q2 = null;
            BigInteger coef = null;
            try {
                p1 = new BigInteger("ff3563654cf386303bf992e36d247c426a49582bce1176ef0141e07ca5cebe36f1bfd17168d93bebe4f793f138426f25271111bbbde41b26ae5b0e08ad34e29d".getBytes("UTF-8"));
                p2 = new BigInteger("2efc3edef58e42763465786a4249c9ed74edf7121cb76198c840f5c47f60ce5e420ef1a99e6ca5eaa643059dec32db231225e58aafeaaf00972ddbbee0799ed9".getBytes("UTF-8"));
                q1 = new BigInteger("567770b31f3ca54498ce0e4f150a97b2f51ec65e2c9140fb9032dfa0f14223965d34993dfcccdee4eb2eaa46647e1a0dd769d6282d46dff04ca4cac482effe71".getBytes("UTF-8"));
                q2 = new BigInteger("2a56191b994dacb8a275c2e594d14f1cda5e3955324f2d8fcdca7ab5d093108961e7fbe304e44eb8f838b247f37aaf6f343169974e6a8b1277b6b3867f2744d9".getBytes("UTF-8"));
                coef = new BigInteger("750602341519eb77e4311c9e91a31c5677d3b6e88d8be594436b110573afc8a5e4e4957495ad88624958ff732f97f0d71a37cd64abbf260ff9907a0c68c027f4".getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e1) {
                throw new RuntimeCryptoException(" p1,q1,p2,q2 getbytes UTF-8 error.");
            }
            return new AsymmetricCipherKeyPair(new RSAKeyParameters(keyIndex, keyType, publicKey.getBits(), false, n, e), new RSAPrivateCrtKeyParameters(keyIndex, keyType, publicKey.getBits(), n, e, d, p1, p2, q1, q2, coef));
        }
        RSArefKeyPair keyPair = null;
        try {
            keyPair = exponent == null || exponent.intValue() == 65537 ? device.generateRSAKeyPair(strength) : device.generateRSAKeyPair(strength, exponent.intValue());
        }
        catch (Exception ex) {
            throw new RuntimeCryptoException("Generate RSA key pair error", ex);
        }
        IRSArefPrivateKey privateKey = keyPair.getPrivateKey();
        BigInteger e = BigIntegerUitl.toPositiveInteger(privateKey.getE());
        BigInteger n = BigIntegerUitl.toPositiveInteger(privateKey.getM());
        BigInteger d = BigIntegerUitl.toPositiveInteger(privateKey.getD());
        BigInteger p1 = BigIntegerUitl.toPositiveInteger(privateKey.getPrime1());
        BigInteger p2 = BigIntegerUitl.toPositiveInteger(privateKey.getPrime2());
        BigInteger q1 = BigIntegerUitl.toPositiveInteger(privateKey.getPexp1());
        BigInteger q2 = BigIntegerUitl.toPositiveInteger(privateKey.getPexp2());
        BigInteger coef = BigIntegerUitl.toPositiveInteger(privateKey.getCoef());
        return new AsymmetricCipherKeyPair(new RSAKeyParameters(privateKey.getBits(), false, n, e), new RSAPrivateCrtKeyParameters(privateKey.getBits(), n, e, d, p1, p2, q1, q2, coef));
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (RSAKeyGenerationParameters)param;
    }
}

