/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.generators;

import com.sansec.crypto.AsymmetricCipherKeyPair;
import com.sansec.crypto.KeyGenerationParameters;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.generators.SM2KeyPairGenerator;
import com.sansec.crypto.params.SM2KeyGenerationParameters;
import com.sansec.crypto.params.SM2KeyParameters;
import com.sansec.crypto.params.SM2PrivateKeyParameters;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refKeyPair;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPrivateKey;
import com.sansec.devicev4.gb.struct.key.sm2.SM2refPublicKey;
import com.sansec.util.BigIntegerUitl;
import com.sansec.util.KeyIndexUtil;
import java.math.BigInteger;

public class SM2HsmKeyPairGenerator
extends SM2KeyPairGenerator {
    private SM2KeyGenerationParameters param;

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        int strength = this.param.getStrength();
        ISDSCrypto device = null;
        try {
            device = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Get HSM device instance error", e);
        }
        if (strength >= 65536) {
            int bits;
            int exIndex = strength >> 16;
            KeyIndexUtil.KeyIndexStruct struct = null;
            try {
                struct = KeyIndexUtil.parse2KeyIndex(exIndex);
            }
            catch (Exception e) {
                throw new RuntimeCryptoException("Trans key index error", e);
            }
            int keyIndex = struct.keyIndex;
            int keyType = struct.keyType;
            BigInteger x = null;
            BigInteger y = null;
            try {
                SM2refPublicKey publicKey = device.getSM2PublicKey(keyIndex, keyType);
                bits = publicKey.getBits();
                x = BigIntegerUitl.toPositiveInteger(publicKey.getX());
                y = BigIntegerUitl.toPositiveInteger(publicKey.getY());
            }
            catch (Exception ex) {
                throw new RuntimeCryptoException("Get SM2 public key error", ex);
            }
            BigInteger d = new BigInteger(exIndex + "");
            return new AsymmetricCipherKeyPair(new SM2KeyParameters(keyIndex, keyType, bits, false, x, y), new SM2PrivateKeyParameters(keyIndex, keyType, bits, x, y, d));
        }
        SM2refKeyPair keyPair = null;
        try {
            keyPair = device.generateSM2KeyPair(strength);
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Generate SM2 key pair error", e);
        }
        BigInteger d = null;
        BigInteger x = null;
        BigInteger y = null;
        SM2refPrivateKey privateKey = keyPair.getPrivateKey();
        d = BigIntegerUitl.toPositiveInteger(privateKey.getD());
        SM2refPublicKey publicKey = keyPair.getPublicKey();
        x = BigIntegerUitl.toPositiveInteger(publicKey.getX());
        y = BigIntegerUitl.toPositiveInteger(publicKey.getY());
        int bits = publicKey.getBits();
        return new AsymmetricCipherKeyPair(new SM2KeyParameters(bits, false, x, y), new SM2PrivateKeyParameters(bits, x, y, d));
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (SM2KeyGenerationParameters)param;
    }
}

