/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.macs;

import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.DataLengthException;
import com.sansec.crypto.Mac;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.jcajce.provider.symmetric.HsmSecretKeySpec;
import java.io.ByteArrayOutputStream;
import java.security.InvalidParameterException;

public class HsmMac
implements Mac {
    private ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private String algorithm;
    private int algId;
    private int keyIndex;
    private byte[] keyBits;

    public HsmMac(String algorithm, HsmSecretKeySpec key) {
        this.algorithm = algorithm;
        this.keyIndex = key.getKeyIndex();
        this.keyBits = key.getEncoded();
        if (algorithm.indexOf("SM3") > -1) {
            this.algId = 1;
        } else if (algorithm.indexOf("SHA-1") > -1) {
            this.algId = 2;
        } else if (algorithm.indexOf("SHA-224") > -1) {
            this.algId = 32;
        } else if (algorithm.indexOf("SHA-256") > -1) {
            this.algId = 4;
        } else if (algorithm.indexOf("SHA-384") > -1) {
            this.algId = 16;
        } else if (algorithm.indexOf("SHA-512") > -1) {
            this.algId = 8;
        } else if (algorithm.indexOf("MD5") > -1) {
            this.algId = 128;
        } else {
            throw new InvalidParameterException("Unsupport hmac algorithm : " + algorithm);
        }
    }

    @Override
    public void init(CipherParameters params) throws IllegalArgumentException {
        this.reset();
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithm;
    }

    @Override
    public int getMacSize() {
        return 0;
    }

    @Override
    public void update(byte in) throws IllegalStateException {
        this.stream.write(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) throws DataLengthException, IllegalStateException {
        this.stream.write(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        ISDSCrypto crypto;
        try {
            crypto = SwxaDeviceFactory.getInstance();
        }
        catch (CryptoException e) {
            throw new RuntimeCryptoException("Get HSM device instance error", e);
        }
        byte[] input = this.stream.toByteArray();
        if (input.length > 8000) {
            throw new DataLengthException("Hmac input length cannot >8000 byte.");
        }
        this.reset();
        byte[] tmp = null;
        if (this.keyIndex > 0) {
            try {
                tmp = crypto.generateHMAC(this.algId, this.keyIndex, input);
            }
            catch (CryptoException e) {
                throw new RuntimeCryptoException("Generate HMAC error", e);
            }
        }
        try {
            tmp = crypto.generateHMAC(this.algId, this.keyBits, input);
        }
        catch (CryptoException e) {
            throw new RuntimeCryptoException("Generate HMAC error", e);
        }
        if (tmp.length > out.length - outOff) {
            throw new DataLengthException("Out data buffer too small");
        }
        System.arraycopy(tmp, 0, out, outOff, tmp.length);
        return tmp.length;
    }

    @Override
    public void reset() {
        this.stream.reset();
    }
}

