/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.params;

import com.sansec.crypto.params.AsymmetricKeyParameter;
import com.sansec.util.Arrays;
import com.sansec.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class Ed25519PublicKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 32;
    private final byte[] data = new byte[32];

    public Ed25519PublicKeyParameters(int keyIndex, int keyType, int bits, boolean isPrivateKey, byte[] buf, int off) {
        super(isPrivateKey, keyIndex, keyType, bits);
        this.bits = bits;
        System.arraycopy(buf, off, this.data, 0, buf.length);
    }

    public Ed25519PublicKeyParameters(byte[] buf, int off) {
        super(false);
        System.arraycopy(buf, off, this.data, 0, 32);
    }

    public Ed25519PublicKeyParameters(InputStream input) throws IOException {
        super(false);
        if (32 != Streams.readFully(input, this.data)) {
            throw new EOFException("EOF encountered in middle of Ed25519 public key");
        }
    }

    public void encode(byte[] buf, int off) {
        System.arraycopy(this.data, 0, buf, off, 32);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }
}

