/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.params;

import com.sansec.crypto.params.RSAKeyParameters;
import java.math.BigInteger;

public class RSAPrivateCrtKeyParameters
extends RSAKeyParameters {
    private BigInteger e;
    private BigInteger p;
    private BigInteger q;
    private BigInteger dP;
    private BigInteger dQ;
    private BigInteger qInv;
    private String keyLabel;

    public RSAPrivateCrtKeyParameters(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger p, BigInteger q, BigInteger dP, BigInteger dQ, BigInteger qInv) {
        super(true, modulus, privateExponent);
        this.e = publicExponent;
        this.p = p;
        this.q = q;
        this.dP = dP;
        this.dQ = dQ;
        this.qInv = qInv;
    }

    public RSAPrivateCrtKeyParameters(int bits, BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger p, BigInteger q, BigInteger dP, BigInteger dQ, BigInteger qInv) {
        super(bits, true, modulus, privateExponent);
        this.e = publicExponent;
        this.p = p;
        this.q = q;
        this.dP = dP;
        this.dQ = dQ;
        this.qInv = qInv;
    }

    public RSAPrivateCrtKeyParameters(int keyIndex, int keyType, int bits, BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger p, BigInteger q, BigInteger dP, BigInteger dQ, BigInteger qInv) {
        super(keyIndex, keyType, bits, true, modulus, privateExponent);
        this.e = publicExponent;
        this.p = p;
        this.q = q;
        this.dP = dP;
        this.dQ = dQ;
        this.qInv = qInv;
    }

    public RSAPrivateCrtKeyParameters(int keyIndex, String keyLabel, int keyType, int bits, BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger p, BigInteger q, BigInteger dP, BigInteger dQ, BigInteger qInv) {
        super(keyIndex, keyType, bits, true, modulus, privateExponent);
        this.e = publicExponent;
        this.p = p;
        this.q = q;
        this.dP = dP;
        this.dQ = dQ;
        this.qInv = qInv;
        this.keyLabel = keyLabel;
    }

    public BigInteger getPublicExponent() {
        return this.e;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getDP() {
        return this.dP;
    }

    public BigInteger getDQ() {
        return this.dQ;
    }

    public BigInteger getQInv() {
        return this.qInv;
    }

    @Override
    public String getKeyLabel() {
        return this.keyLabel;
    }
}

