/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.signers;

import com.sansec.asn1.pkcs.DSASignStructure;
import com.sansec.asn1.pkcs.DSAStructureUtil;
import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.params.DSAKeyParameters;
import com.sansec.crypto.params.DSAParameters;
import com.sansec.crypto.params.DSAPrivateKeyParameters;
import com.sansec.crypto.params.DSAPublicKeyParameters;
import com.sansec.crypto.params.ParametersWithRandom;
import com.sansec.crypto.signers.DSASigner;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.IDSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.IDSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.dsa.DSArefPrivateKeyEx;
import com.sansec.devicev4.gb.struct.key.dsa.DSArefPrivateKeyLite;
import com.sansec.devicev4.gb.struct.key.dsa.DSArefPublicKeyEx;
import com.sansec.devicev4.gb.struct.key.dsa.DSArefPublicKeyLite;
import com.sansec.devicev4.gb.struct.key.dsa.DSArefSignature;
import com.sansec.devicev4.log.CryptoLogger;
import com.sansec.devicev4.util.PrintUtil;
import com.sansec.util.BigIntegerUitl;
import com.sansec.util.encoders.Hex;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DSAHsmSigner
extends DSASigner {
    protected DSAKeyParameters key;
    private Logger logger = CryptoLogger.logger;

    @Override
    public void init(boolean forSign, CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (DSAKeyParameters)rParam.getParameters();
        } else {
            this.key = (DSAKeyParameters)param;
        }
    }

    @Override
    public BigInteger[] generateSignature(byte[] in) {
        if (this.key == null) {
            throw new IllegalStateException("DSA sign engine not initialised");
        }
        DSArefSignature signature = null;
        byte[] dataInput = in;
        ISDSCrypto device = null;
        try {
            device = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Get HSM device instance error", e);
        }
        DSAPrivateKeyParameters keyParam = (DSAPrivateKeyParameters)this.key;
        int keyIndex = keyParam.getKeyIndex();
        int keyType = keyParam.getKeyType();
        if (keyIndex == 0) {
            byte[] y;
            DSArefPrivateKeyEx privateKey = null;
            byte[] x = BigIntegerUitl.asUnsigned32ByteArray(keyParam.getX());
            DSAParameters dsaParameters = this.key.getParameters();
            byte[] p = dsaParameters.getP().toByteArray();
            byte[] q = dsaParameters.getQ().toByteArray();
            byte[] g = dsaParameters.getG().toByteArray();
            int bits = this.key.getBits();
            if (bits > 2048) {
                y = new byte[512];
                privateKey = new DSArefPrivateKeyEx(bits, p, q, g, y, x);
                this.logger.fine(privateKey.toString());
            } else {
                y = new byte[256];
                privateKey = new DSArefPrivateKeyLite(bits, p, q, g, y, x);
                this.logger.fine(privateKey.toString());
            }
            try {
                signature = device.dsaSign((IDSArefPrivateKey)privateKey, dataInput);
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "DSASign error");
                    this.logger.log(Level.INFO, "privatekey:\n" + privateKey.toString());
                    this.logger.log(Level.INFO, "data input:\n" + PrintUtil.toHexString((byte[])dataInput));
                }
                throw new RuntimeCryptoException("External DSA private key signature error", e);
            }
        }
        try {
            signature = device.dsaSign(keyIndex, keyType, dataInput);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, "DSASign error");
                this.logger.log(Level.INFO, "keyIndex:\n" + keyIndex);
                this.logger.log(Level.INFO, "data input:\n" + PrintUtil.toHexString((byte[])dataInput));
            }
            throw new RuntimeCryptoException("Internal DSA private key signature error", e);
        }
        DSASignStructure signatureSt = DSAStructureUtil.convert(signature);
        return new BigInteger[]{signatureSt.getR(), signatureSt.getS()};
    }

    @Override
    public boolean verifySignature(byte[] in, BigInteger r, BigInteger s) {
        boolean flag;
        if (this.key == null) {
            throw new IllegalStateException("DSA sign engine not initialised");
        }
        byte[] dataInput = in;
        ISDSCrypto device = null;
        try {
            device = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Get HSM device instance error", e);
        }
        DSAPublicKeyParameters keyParam = (DSAPublicKeyParameters)this.key;
        int keyIndex = keyParam.getKeyIndex();
        int keyType = keyParam.getKeyType();
        int bits = keyParam.getBits();
        DSArefSignature signature = null;
        try {
            DSASignStructure signatureSt = new DSASignStructure(r, s);
            signature = DSAStructureUtil.convert(bits, signatureSt);
        }
        catch (Exception e) {
            String str = null;
            try {
                str = new String(Hex.encode(dataInput), "UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                throw new RuntimeCryptoException("dataInput to utf-8 error", e1);
            }
            this.logger.log(Level.INFO, "DSA signed data:" + str);
            throw new RuntimeCryptoException("DSA signature structure error", e);
        }
        if (keyIndex == 0) {
            DSArefPublicKeyEx publicKey = null;
            byte[] y = keyParam.getY().toByteArray();
            byte[] p = this.key.getParameters().getP().toByteArray();
            byte[] q = this.key.getParameters().getQ().toByteArray();
            byte[] g = this.key.getParameters().getG().toByteArray();
            if (bits > 2048) {
                publicKey = new DSArefPublicKeyEx(bits, p, q, g, y);
                this.logger.fine(publicKey.toString());
            } else {
                publicKey = new DSArefPublicKeyLite(bits, p, q, g, y);
                this.logger.fine(publicKey.toString());
            }
            try {
                flag = device.dsaVerify((IDSArefPublicKey)publicKey, dataInput, signature);
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "DSAVerify error", e);
                    this.logger.log(Level.INFO, "publicKey:\n" + publicKey.toString());
                    this.logger.log(Level.INFO, "signature:\n" + signature.toString());
                    this.logger.log(Level.INFO, "data input:\n" + PrintUtil.toHexString((byte[])dataInput));
                }
                throw new RuntimeCryptoException("External DSA public key verification error", e);
            }
        }
        try {
            flag = device.dsaVerify(keyIndex, keyType, dataInput, signature);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, "DSAVerify error", e);
                this.logger.log(Level.INFO, "keyIndex:\n" + keyIndex);
                this.logger.log(Level.INFO, "signature:\n" + signature.toString());
                this.logger.log(Level.INFO, "data input:\n" + PrintUtil.toHexString((byte[])dataInput));
            }
            throw new RuntimeCryptoException("Internal DSA public key verification error", e);
        }
        return flag;
    }
}

