/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.signers;

import com.sansec.crypto.CipherParameters;
import com.sansec.crypto.RuntimeCryptoException;
import com.sansec.crypto.Signer;
import com.sansec.crypto.params.Ed25519PrivateKeyParameters;
import com.sansec.crypto.params.Ed25519PublicKeyParameters;
import com.sansec.devicev4.SwxaDeviceFactory;
import com.sansec.devicev4.api.CryptoException;
import com.sansec.devicev4.api.ISDSCrypto;
import com.sansec.devicev4.gb.struct.key.ed.EdDSArefPrivateKey;
import com.sansec.devicev4.gb.struct.key.ed.EdDSArefPublicKey;
import com.sansec.devicev4.gb.struct.key.ed.EdDSArefSignature;
import com.sansec.devicev4.log.CryptoLogger;
import com.sansec.devicev4.util.BytesUtil;
import com.sansec.devicev4.util.PrintUtil;
import com.sansec.util.Arrays;
import com.sansec.util.KeyIndexUtil;
import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Ed25519HSMSigner
implements Signer {
    private Logger logger = CryptoLogger.logger;
    private final Buffer buffer = new Buffer();
    private boolean forSigning;
    private Ed25519PrivateKeyParameters privateKey;
    private Ed25519PublicKeyParameters publicKey;

    @Override
    public void init(boolean forSigning, CipherParameters parameters) {
        this.forSigning = forSigning;
        if (forSigning) {
            this.privateKey = (Ed25519PrivateKeyParameters)parameters;
            this.publicKey = null;
        } else {
            this.privateKey = null;
            this.publicKey = (Ed25519PublicKeyParameters)parameters;
        }
        this.reset();
    }

    @Override
    public void update(byte b) {
        this.buffer.write(b);
    }

    @Override
    public void update(byte[] buf, int off, int len) {
        this.buffer.write(buf, off, len);
    }

    @Override
    public byte[] generateSignature() {
        if (!this.forSigning || null == this.privateKey) {
            throw new IllegalStateException("Ed25519Signer not initialised for signature generation.");
        }
        byte[] signature = new byte[64];
        EdDSArefSignature edDSArefSignature = null;
        byte[] dataInput = this.buffer.toByteArray();
        ISDSCrypto device = null;
        try {
            device = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Get HSM device instance error", e);
        }
        Ed25519PrivateKeyParameters keyParam = this.privateKey;
        byte[] data = keyParam.getEncoded();
        int keyIndex = keyParam.getKeyIndex();
        int keyType = keyParam.getKeyType();
        byte[] a = new byte[30];
        byte[] b = new byte[30];
        System.arraycopy(data, 1, b, 0, 30);
        if (BytesUtil.isEqual((byte[])a, (byte[])b)) {
            try {
                byte dint = data[0];
                KeyIndexUtil.KeyIndexStruct struct = KeyIndexUtil.parse2KeyIndex(dint);
                keyIndex = struct.keyIndex;
                keyType = struct.keyType;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (keyIndex == 0) {
            byte[] d = new byte[80];
            System.arraycopy(keyParam.getEncoded(), 0, d, 48, 32);
            EdDSArefPrivateKey privateKey = new EdDSArefPrivateKey(256, 1, d);
            try {
                edDSArefSignature = device.eddsaSign(privateKey, dataInput);
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "eddsaSign error");
                    this.logger.log(Level.INFO, "privatekey:\n" + privateKey.toString());
                    this.logger.log(Level.INFO, "data input:\n" + PrintUtil.toHexString((byte[])dataInput));
                }
                throw new RuntimeCryptoException("External eddsa private key signature error", e);
            }
        }
        try {
            edDSArefSignature = device.eddsaSign(keyIndex, keyType, dataInput);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, "eddsaSign error");
                this.logger.log(Level.INFO, "keyIndex:\n" + keyIndex);
                this.logger.log(Level.INFO, "data input:\n" + PrintUtil.toHexString((byte[])dataInput));
            }
            throw new RuntimeCryptoException("Internal eddsa private key signature error", e);
        }
        System.arraycopy(edDSArefSignature.r, 0, signature, 0, 32);
        System.arraycopy(edDSArefSignature.s, 0, signature, 32, 32);
        this.reset();
        return signature;
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        boolean flag;
        if (this.forSigning || null == this.publicKey) {
            throw new IllegalStateException("Ed25519Signer not initialised for verification");
        }
        byte[] dataInput = this.buffer.toByteArray();
        ISDSCrypto device = null;
        try {
            device = SwxaDeviceFactory.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeCryptoException("Get HSM device instance error", e);
        }
        Ed25519PublicKeyParameters keyParam = this.publicKey;
        int keyIndex = keyParam.getKeyIndex();
        int keyType = keyParam.getKeyType();
        EdDSArefSignature edDSArefSignature = new EdDSArefSignature();
        try {
            edDSArefSignature.decode(signature);
        }
        catch (CryptoException e) {
            this.logger.log(Level.INFO, "eddsaSign error,edDSArefSignature.decode()");
        }
        if (keyIndex == 0) {
            byte[] A = this.publicKey.getEncoded();
            System.arraycopy(this.publicKey.getEncoded(), 0, A, 0, 32);
            EdDSArefPublicKey publicKey = new EdDSArefPublicKey(256, 1, A);
            try {
                flag = device.eddsaVerify(publicKey, dataInput, edDSArefSignature);
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.log(Level.INFO, "eddsaVerify error", e);
                    this.logger.log(Level.INFO, "publicKey:\n" + publicKey.toString());
                    this.logger.log(Level.INFO, "signature:\n" + signature.toString());
                    this.logger.log(Level.INFO, "data input:\n" + PrintUtil.toHexString((byte[])dataInput));
                }
                throw new RuntimeCryptoException("External Eddsa public key verification error", e);
            }
        }
        try {
            flag = device.eddsaVerify(keyIndex, keyType, dataInput, edDSArefSignature);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, "eddsaVerify error", e);
                this.logger.log(Level.INFO, "keyIndex:\n" + keyIndex);
                this.logger.log(Level.INFO, "signature:\n" + signature.toString());
                this.logger.log(Level.INFO, "data input:\n" + PrintUtil.toHexString((byte[])dataInput));
            }
            throw new RuntimeCryptoException("Internal Eddsa public key verification error", e);
        }
        return flag;
    }

    @Override
    public void reset() {
        this.buffer.reset();
    }

    private static class Buffer
    extends ByteArrayOutputStream {
        private Buffer() {
        }

        @Override
        public synchronized void reset() {
            Arrays.fill(this.buf, 0, this.count, (byte)0);
            this.count = 0;
        }
    }
}

