/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.tls;

import com.sansec.crypto.agreement.srp.SRP6StandardGroups;
import com.sansec.crypto.params.SRP6GroupParameters;
import com.sansec.crypto.tls.TlsSRPGroupVerifier;
import java.math.BigInteger;
import java.util.Vector;

public class DefaultTlsSRPGroupVerifier
implements TlsSRPGroupVerifier {
    protected static final Vector DEFAULT_GROUPS = new Vector();
    protected Vector groups;

    public DefaultTlsSRPGroupVerifier() {
        this(DEFAULT_GROUPS);
    }

    public DefaultTlsSRPGroupVerifier(Vector groups) {
        this.groups = groups;
    }

    @Override
    public boolean accept(SRP6GroupParameters group) {
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!this.areGroupsEqual(group, (SRP6GroupParameters)this.groups.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean areGroupsEqual(SRP6GroupParameters a, SRP6GroupParameters b) {
        return a == b || this.areParametersEqual(a.getN(), b.getN()) && this.areParametersEqual(a.getG(), b.getG());
    }

    protected boolean areParametersEqual(BigInteger a, BigInteger b) {
        return a == b || a.equals(b);
    }

    static {
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_1024);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_1536);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_2048);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_3072);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_4096);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_6144);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_8192);
    }
}

