/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.util;

import com.sansec.asn1.ASN1EncodableVector;
import com.sansec.asn1.ASN1Integer;
import com.sansec.asn1.ASN1ObjectIdentifier;
import com.sansec.asn1.ASN1Sequence;
import com.sansec.asn1.ASN1TaggedObject;
import com.sansec.asn1.DERSequence;
import com.sansec.asn1.nist.NISTNamedCurves;
import com.sansec.asn1.pkcs.PrivateKeyInfo;
import com.sansec.asn1.pkcs.RSAPrivateKey;
import com.sansec.asn1.sec.ECPrivateKey;
import com.sansec.asn1.x9.ECNamedCurveTable;
import com.sansec.asn1.x9.X9ECParameters;
import com.sansec.crypto.CryptoServicesRegistrar;
import com.sansec.crypto.params.AsymmetricKeyParameter;
import com.sansec.crypto.params.DSAParameters;
import com.sansec.crypto.params.DSAPrivateKeyParameters;
import com.sansec.crypto.params.ECDomainParameters;
import com.sansec.crypto.params.ECNamedDomainParameters;
import com.sansec.crypto.params.ECPrivateKeyParameters;
import com.sansec.crypto.params.Ed25519PrivateKeyParameters;
import com.sansec.crypto.params.Ed25519PublicKeyParameters;
import com.sansec.crypto.params.RSAPrivateCrtKeyParameters;
import com.sansec.crypto.util.OpenSSHPublicKeyUtil;
import com.sansec.crypto.util.PrivateKeyInfoFactory;
import com.sansec.crypto.util.SSHBuffer;
import com.sansec.crypto.util.SSHBuilder;
import com.sansec.crypto.util.SSHNamedCurves;
import com.sansec.util.Arrays;
import com.sansec.util.BigIntegers;
import com.sansec.util.Strings;
import java.io.IOException;
import java.math.BigInteger;

public class OpenSSHPrivateKeyUtil {
    static final byte[] AUTH_MAGIC = Strings.toByteArray("openssh-key-v1\u0000");

    private OpenSSHPrivateKeyUtil() {
    }

    public static byte[] encodePrivateKey(AsymmetricKeyParameter params) throws IOException {
        if (params == null) {
            throw new IllegalArgumentException("param is null");
        }
        if (params instanceof RSAPrivateCrtKeyParameters) {
            PrivateKeyInfo pInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(params);
            return pInfo.parsePrivateKey().toASN1Primitive().getEncoded();
        }
        if (params instanceof ECPrivateKeyParameters) {
            PrivateKeyInfo pInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(params);
            return pInfo.parsePrivateKey().toASN1Primitive().getEncoded();
        }
        if (params instanceof DSAPrivateKeyParameters) {
            DSAPrivateKeyParameters dsaPrivKey = (DSAPrivateKeyParameters)params;
            DSAParameters dsaParams = dsaPrivKey.getParameters();
            ASN1EncodableVector vec = new ASN1EncodableVector();
            vec.add(new ASN1Integer(0L));
            vec.add(new ASN1Integer(dsaParams.getP()));
            vec.add(new ASN1Integer(dsaParams.getQ()));
            vec.add(new ASN1Integer(dsaParams.getG()));
            BigInteger pubKey = dsaParams.getG().modPow(dsaPrivKey.getX(), dsaParams.getP());
            vec.add(new ASN1Integer(pubKey));
            vec.add(new ASN1Integer(dsaPrivKey.getX()));
            try {
                return new DERSequence(vec).getEncoded();
            }
            catch (Exception ex) {
                throw new IllegalStateException("unable to encode DSAPrivateKeyParameters " + ex.getMessage());
            }
        }
        if (params instanceof Ed25519PrivateKeyParameters) {
            Ed25519PublicKeyParameters publicKeyParameters = ((Ed25519PrivateKeyParameters)params).generatePublicKey();
            SSHBuilder builder = new SSHBuilder();
            builder.writeBytes(AUTH_MAGIC);
            builder.writeString("none");
            builder.writeString("none");
            builder.writeString("");
            builder.u32(1);
            byte[] pkEncoded = OpenSSHPublicKeyUtil.encodePublicKey(publicKeyParameters);
            builder.writeBlock(pkEncoded);
            SSHBuilder pkBuild = new SSHBuilder();
            int checkint = CryptoServicesRegistrar.getSecureRandom().nextInt();
            pkBuild.u32(checkint);
            pkBuild.u32(checkint);
            pkBuild.writeString("ssh-ed25519");
            byte[] pubKeyEncoded = publicKeyParameters.getEncoded();
            pkBuild.writeBlock(pubKeyEncoded);
            pkBuild.writeBlock(Arrays.concatenate(((Ed25519PrivateKeyParameters)params).getEncoded(), pubKeyEncoded));
            pkBuild.writeString("");
            builder.writeBlock(pkBuild.getPaddedBytes());
            return builder.getBytes();
        }
        throw new IllegalArgumentException("unable to convert " + params.getClass().getName() + " to openssh private key");
    }

    public static AsymmetricKeyParameter parsePrivateKeyBlob(byte[] blob) {
        AsymmetricKeyParameter result = null;
        if (blob[0] == 48) {
            ASN1Sequence sequence = ASN1Sequence.getInstance(blob);
            if (sequence.size() == 6) {
                if (OpenSSHPrivateKeyUtil.allIntegers(sequence) && ((ASN1Integer)sequence.getObjectAt(0)).getPositiveValue().equals(BigIntegers.ZERO)) {
                    result = new DSAPrivateKeyParameters(((ASN1Integer)sequence.getObjectAt(5)).getPositiveValue(), new DSAParameters(((ASN1Integer)sequence.getObjectAt(1)).getPositiveValue(), ((ASN1Integer)sequence.getObjectAt(2)).getPositiveValue(), ((ASN1Integer)sequence.getObjectAt(3)).getPositiveValue()));
                }
            } else if (sequence.size() == 9) {
                if (OpenSSHPrivateKeyUtil.allIntegers(sequence) && ((ASN1Integer)sequence.getObjectAt(0)).getPositiveValue().equals(BigIntegers.ZERO)) {
                    RSAPrivateKey rsaPrivateKey = RSAPrivateKey.getInstance(sequence);
                    result = new RSAPrivateCrtKeyParameters(rsaPrivateKey.getModulus(), rsaPrivateKey.getPublicExponent(), rsaPrivateKey.getPrivateExponent(), rsaPrivateKey.getPrime1(), rsaPrivateKey.getPrime2(), rsaPrivateKey.getExponent1(), rsaPrivateKey.getExponent2(), rsaPrivateKey.getCoefficient());
                }
            } else if (sequence.size() == 4 && sequence.getObjectAt(3) instanceof ASN1TaggedObject && sequence.getObjectAt(2) instanceof ASN1TaggedObject) {
                ECPrivateKey ecPrivateKey = ECPrivateKey.getInstance(sequence);
                ASN1ObjectIdentifier curveOID = (ASN1ObjectIdentifier)ecPrivateKey.getParameters();
                X9ECParameters x9Params = ECNamedCurveTable.getByOID(curveOID);
                result = new ECPrivateKeyParameters(ecPrivateKey.getKey(), (ECDomainParameters)new ECNamedDomainParameters(curveOID, x9Params));
            }
        } else {
            int check2;
            SSHBuffer kIn = new SSHBuffer(AUTH_MAGIC, blob);
            String cipherName = kIn.readString();
            if (!"none".equals(cipherName)) {
                throw new IllegalStateException("encrypted keys not supported");
            }
            kIn.skipBlock();
            kIn.skipBlock();
            int publicKeyCount = kIn.readU32();
            if (publicKeyCount != 1) {
                throw new IllegalStateException("multiple keys not supported");
            }
            OpenSSHPublicKeyUtil.parsePublicKey(kIn.readBlock());
            byte[] privateKeyBlock = kIn.readPaddedBlock();
            if (kIn.hasRemaining()) {
                throw new IllegalArgumentException("decoded key has trailing data");
            }
            SSHBuffer pkIn = new SSHBuffer(privateKeyBlock);
            int check1 = pkIn.readU32();
            if (check1 != (check2 = pkIn.readU32())) {
                throw new IllegalStateException("private key check values are not the same");
            }
            String keyType = pkIn.readString();
            if ("ssh-ed25519".equals(keyType)) {
                pkIn.readBlock();
                byte[] edPrivateKey = pkIn.readBlock();
                if (edPrivateKey.length != 64) {
                    throw new IllegalStateException("private key value of wrong length");
                }
                result = new Ed25519PrivateKeyParameters(edPrivateKey, 0);
            } else if (keyType.startsWith("ecdsa")) {
                ASN1ObjectIdentifier oid = SSHNamedCurves.getByName(Strings.fromByteArray(pkIn.readBlock()));
                if (oid == null) {
                    throw new IllegalStateException("OID not found for: " + keyType);
                }
                X9ECParameters curveParams = NISTNamedCurves.getByOID(oid);
                if (curveParams == null) {
                    throw new IllegalStateException("Curve not found for: " + oid);
                }
                pkIn.readBlock();
                byte[] privKey = pkIn.readBlock();
                result = new ECPrivateKeyParameters(new BigInteger(1, privKey), (ECDomainParameters)new ECNamedDomainParameters(oid, curveParams));
            }
            pkIn.skipBlock();
            if (pkIn.hasRemaining()) {
                throw new IllegalArgumentException("private key block has trailing data");
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("unable to parse key");
        }
        return result;
    }

    private static boolean allIntegers(ASN1Sequence sequence) {
        for (int t = 0; t < sequence.size(); ++t) {
            if (sequence.getObjectAt(t) instanceof ASN1Integer) continue;
            return false;
        }
        return true;
    }
}

