/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.crypto.util;

import com.sansec.asn1.ASN1Encodable;
import com.sansec.asn1.ASN1InputStream;
import com.sansec.asn1.ASN1Integer;
import com.sansec.asn1.ASN1ObjectIdentifier;
import com.sansec.asn1.ASN1Primitive;
import com.sansec.asn1.oiw.ElGamalParameter;
import com.sansec.asn1.oiw.OIWObjectIdentifiers;
import com.sansec.asn1.pkcs.DHParameter;
import com.sansec.asn1.pkcs.GBObjectIdentifiers;
import com.sansec.asn1.pkcs.PKCSObjectIdentifiers;
import com.sansec.asn1.pkcs.PrivateKeyInfo;
import com.sansec.asn1.pkcs.RSAPrivateKeyStructure;
import com.sansec.asn1.pkcs.SM2PrivateKeyStructure;
import com.sansec.asn1.pkcs.SM2PublicKeyStructure;
import com.sansec.asn1.sec.ECPrivateKey;
import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.asn1.x509.DSAParameter;
import com.sansec.asn1.x9.ECNamedCurveTable;
import com.sansec.asn1.x9.X962Parameters;
import com.sansec.asn1.x9.X9ECParameters;
import com.sansec.asn1.x9.X9ObjectIdentifiers;
import com.sansec.crypto.ec.CustomNamedCurves;
import com.sansec.crypto.params.AsymmetricKeyParameter;
import com.sansec.crypto.params.DHParameters;
import com.sansec.crypto.params.DHPrivateKeyParameters;
import com.sansec.crypto.params.DSAParameters;
import com.sansec.crypto.params.DSAPrivateKeyParameters;
import com.sansec.crypto.params.ECDomainParameters;
import com.sansec.crypto.params.ECNamedDomainParameters;
import com.sansec.crypto.params.ECPrivateKeyParameters;
import com.sansec.crypto.params.ElGamalParameters;
import com.sansec.crypto.params.ElGamalPrivateKeyParameters;
import com.sansec.crypto.params.RSAPrivateCrtKeyParameters;
import com.sansec.crypto.params.SM2PrivateKeyParameters;
import com.sansec.util.KeyIndexUtil;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.spec.ECPoint;

public class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] privateKeyInfoData) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(privateKeyInfoData)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inStr) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(new ASN1InputStream(inStr).readObject()));
    }

    public static AsymmetricKeyParameter createKey(PrivateKeyInfo keyInfo) throws IOException {
        AlgorithmIdentifier algId = keyInfo.getPrivateKeyAlgorithm();
        if (algId.getAlgorithm().equals(PKCSObjectIdentifiers.rsaEncryption)) {
            RSAPrivateKeyStructure keyStructure = RSAPrivateKeyStructure.getInstance(keyInfo.parsePrivateKey());
            BigInteger d = keyStructure.getPrivateExponent();
            int dint = d.intValue();
            if (dint > 0 && dint <= 100 && d.bitLength() < 32) {
                try {
                    KeyIndexUtil.KeyIndexStruct struct = KeyIndexUtil.parse2KeyIndex(dint);
                    return new RSAPrivateCrtKeyParameters(struct.keyIndex, struct.keyType, keyStructure.getModulus().bitLength(), keyStructure.getModulus(), keyStructure.getPublicExponent(), keyStructure.getPrivateExponent(), keyStructure.getPrime1(), keyStructure.getPrime2(), keyStructure.getExponent1(), keyStructure.getExponent2(), keyStructure.getCoefficient());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return new RSAPrivateCrtKeyParameters(keyStructure.getModulus(), keyStructure.getPublicExponent(), keyStructure.getPrivateExponent(), keyStructure.getPrime1(), keyStructure.getPrime2(), keyStructure.getExponent1(), keyStructure.getExponent2(), keyStructure.getCoefficient());
        }
        if (algId.getAlgorithm().equals(PKCSObjectIdentifiers.dhKeyAgreement)) {
            DHParameter params = DHParameter.getInstance(algId.getParameters());
            ASN1Integer derX = (ASN1Integer)keyInfo.parsePrivateKey();
            BigInteger lVal = params.getL();
            int l = lVal == null ? 0 : lVal.intValue();
            DHParameters dhParams = new DHParameters(params.getP(), params.getG(), null, l);
            return new DHPrivateKeyParameters(derX.getValue(), dhParams);
        }
        if (algId.getAlgorithm().equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter params = ElGamalParameter.getInstance(algId.getParameters());
            ASN1Integer derX = (ASN1Integer)keyInfo.parsePrivateKey();
            return new ElGamalPrivateKeyParameters(derX.getValue(), new ElGamalParameters(params.getP(), params.getG()));
        }
        if (algId.getAlgorithm().equals(X9ObjectIdentifiers.id_dsa)) {
            ASN1Integer derX = (ASN1Integer)keyInfo.parsePrivateKey();
            ASN1Encodable de = algId.getParameters();
            DSAParameters parameters = null;
            if (de != null) {
                DSAParameter params = DSAParameter.getInstance(de.toASN1Primitive());
                parameters = new DSAParameters(params.getP(), params.getQ(), params.getG());
            }
            return new DSAPrivateKeyParameters(derX.getValue(), parameters);
        }
        if (algId.getAlgorithm().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            ECDomainParameters dParams;
            ASN1ObjectIdentifier paramOID;
            ASN1Encodable parameters = algId.getParameters();
            if (parameters != null && parameters instanceof ASN1ObjectIdentifier && (paramOID = (ASN1ObjectIdentifier)parameters).equals(GBObjectIdentifiers.sm2)) {
                SM2PrivateKeyStructure privateKeyStructure = SM2PrivateKeyStructure.getInstance(keyInfo.parsePrivateKey());
                ECPoint w = new SM2PublicKeyStructure(privateKeyStructure.getPublicKey()).getQ();
                return new SM2PrivateKeyParameters(0, 0, 256, w.getAffineX(), w.getAffineY(), privateKeyStructure.getKey());
            }
            X962Parameters params = X962Parameters.getInstance(algId.getParameters());
            if (params.isNamedCurve()) {
                ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)params.getParameters();
                X9ECParameters x9 = CustomNamedCurves.getByOID(oid);
                if (x9 == null) {
                    x9 = ECNamedCurveTable.getByOID(oid);
                }
                dParams = new ECNamedDomainParameters(oid, x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
            } else {
                X9ECParameters x9 = X9ECParameters.getInstance(params.getParameters());
                dParams = new ECDomainParameters(x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
            }
            ECPrivateKey ec = ECPrivateKey.getInstance(keyInfo.parsePrivateKey());
            BigInteger d = ec.getKey();
            return new ECPrivateKeyParameters(d, dParams);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }
}

