/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.jcajce.provider.asymmetric;

import com.sansec.asn1.ASN1ObjectIdentifier;
import com.sansec.asn1.nist.NISTObjectIdentifiers;
import com.sansec.jcajce.provider.asymmetric.dsa.DSAUtil;
import com.sansec.jcajce.provider.asymmetric.dsa.KeyFactorySpi;
import com.sansec.jcajce.provider.config.ConfigurableProvider;
import com.sansec.jcajce.provider.util.AsymmetricAlgorithmProvider;

public class DSA {
    private static final String PREFIX = "com.sansec.jcajce.provider.asymmetric.dsa.";

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("AlgorithmParameters.DSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSAAlgorithmParametersSpi");
            provider.addAlgorithm("AlgorithmParameterGenerator.DSA", "com.sansec.jcajce.provider.asymmetric.dsa.AlgorithmParameterGeneratorSpi");
            provider.addAlgorithm("KeyPairGenerator.DSA", "com.sansec.jcajce.provider.asymmetric.dsa.KeyPairGeneratorSpi");
            provider.addAlgorithm("KeyFactory.DSA", "com.sansec.jcajce.provider.asymmetric.dsa.KeyFactorySpi");
            provider.addAlgorithm("Signature.DSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$stdDSA");
            provider.addAlgorithm("Signature.NONEWITHDSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$noneDSA");
            provider.addAlgorithm("Alg.Alias.Signature.RAWDSA", "NONEWITHDSA");
            provider.addAlgorithm("Signature.DETDSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$detDSA");
            provider.addAlgorithm("Signature.SHA1WITHDETDSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$detDSA");
            provider.addAlgorithm("Signature.SHA224WITHDETDSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$detDSA224");
            provider.addAlgorithm("Signature.SHA256WITHDETDSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$detDSA256");
            provider.addAlgorithm("Signature.SHA384WITHDETDSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$detDSA384");
            provider.addAlgorithm("Signature.SHA512WITHDETDSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$detDSA512");
            provider.addAlgorithm("Signature.DDSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$detDSA");
            provider.addAlgorithm("Signature.SHA1WITHDDSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$detDSA");
            provider.addAlgorithm("Signature.SHA224WITHDDSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$detDSA224");
            provider.addAlgorithm("Signature.SHA256WITHDDSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$detDSA256");
            provider.addAlgorithm("Signature.SHA384WITHDDSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$detDSA384");
            provider.addAlgorithm("Signature.SHA512WITHDDSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$detDSA512");
            provider.addAlgorithm("Signature.SHA3-224WITHDDSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$detDSASha3_224");
            provider.addAlgorithm("Signature.SHA3-256WITHDDSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$detDSASha3_256");
            provider.addAlgorithm("Signature.SHA3-384WITHDDSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$detDSASha3_384");
            provider.addAlgorithm("Signature.SHA3-512WITHDDSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$detDSASha3_512");
            this.addSignatureAlgorithm(provider, "SHA224", "DSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$dsa224", NISTObjectIdentifiers.dsa_with_sha224);
            this.addSignatureAlgorithm(provider, "SHA256", "DSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$dsa256", NISTObjectIdentifiers.dsa_with_sha256);
            this.addSignatureAlgorithm(provider, "SHA384", "DSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$dsa384", NISTObjectIdentifiers.dsa_with_sha384);
            this.addSignatureAlgorithm(provider, "SHA512", "DSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$dsa512", NISTObjectIdentifiers.dsa_with_sha512);
            this.addSignatureAlgorithm(provider, "SHA3-224", "DSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$dsaSha3_224", NISTObjectIdentifiers.id_dsa_with_sha3_224);
            this.addSignatureAlgorithm(provider, "SHA3-256", "DSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$dsaSha3_256", NISTObjectIdentifiers.id_dsa_with_sha3_256);
            this.addSignatureAlgorithm(provider, "SHA3-384", "DSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$dsaSha3_384", NISTObjectIdentifiers.id_dsa_with_sha3_384);
            this.addSignatureAlgorithm(provider, "SHA3-512", "DSA", "com.sansec.jcajce.provider.asymmetric.dsa.DSASigner$dsaSha3_512", NISTObjectIdentifiers.id_dsa_with_sha3_512);
            provider.addAlgorithm("Alg.Alias.Signature.SHA/DSA", "DSA");
            provider.addAlgorithm("Alg.Alias.Signature.SHA1withDSA", "DSA");
            provider.addAlgorithm("Alg.Alias.Signature.SHA1WITHDSA", "DSA");
            provider.addAlgorithm("Alg.Alias.Signature.1.3.14.3.2.26with1.2.840.10040.4.1", "DSA");
            provider.addAlgorithm("Alg.Alias.Signature.1.3.14.3.2.26with1.2.840.10040.4.3", "DSA");
            provider.addAlgorithm("Alg.Alias.Signature.DSAwithSHA1", "DSA");
            provider.addAlgorithm("Alg.Alias.Signature.DSAWITHSHA1", "DSA");
            provider.addAlgorithm("Alg.Alias.Signature.SHA1WithDSA", "DSA");
            provider.addAlgorithm("Alg.Alias.Signature.DSAWithSHA1", "DSA");
            provider.addAlgorithm("Alg.Alias.Signature.1.2.840.10040.4.3", "DSA");
            KeyFactorySpi keyFact = new KeyFactorySpi();
            ASN1ObjectIdentifier[] dsaOids = DSAUtil.getDsaOids();
            for (int i = 0; i != dsaOids.length; ++i) {
                provider.addAlgorithm("Alg.Alias.Signature." + dsaOids[i], "DSA");
                this.registerOid(provider, dsaOids[i], "DSA", keyFact);
                this.registerOidAlgorithmParameters(provider, dsaOids[i], "DSA");
            }
        }
    }
}

